/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.parser.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.acceleo.common.internal.utils.AcceleoPackageRegistry;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlBinaryResourceFactoryImpl;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.acceleo.parser.AcceleoFile;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoParserProblem;
import org.eclipse.acceleo.parser.AcceleoParserProblems;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAcceleoCompiler {
    private static final String JAR_EXTENSION = ".jar";
    protected boolean binaryResource = true;
    protected File sourceFolder;
    protected File outputFolder;
    protected boolean trimPosition;
    protected List<File> dependencies = new ArrayList<File>();
    protected List<String> dependenciesIDs = new ArrayList<String>();
    protected List<URI> jarEmtlsURI = new ArrayList<URI>();

    public void setSourceFolder(String theSourceFolder) {
        this.sourceFolder = new Path(theSourceFolder).toFile();
    }

    public void setDependencies(String allDependencies) {
        this.dependencies.clear();
        StringTokenizer st = new StringTokenizer(allDependencies, ";");
        while (st.hasMoreTokens()) {
            String path = st.nextToken().trim();
            if (path.length() > 0 && !path.endsWith(JAR_EXTENSION)) {
                File parent = new Path(path).removeLastSegments(1).toFile();
                if (parent == null || !parent.exists() || !parent.isDirectory()) continue;
                String segmentID = new Path(path).lastSegment();
                File[] candidates = parent.listFiles();
                Arrays.sort(candidates, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        return -o1.getName().compareTo(o2.getName());
                    }
                });
                File bestRequiredFolder = null;
                File[] fileArray = candidates;
                int n = candidates.length;
                int n2 = 0;
                while (n2 < n) {
                    File candidate = fileArray[n2];
                    if (candidate.isDirectory() && candidate.getName() != null && candidate.getName().startsWith(segmentID)) {
                        bestRequiredFolder = candidate;
                        break;
                    }
                    ++n2;
                }
                if (bestRequiredFolder == null || this.dependencies.contains(bestRequiredFolder)) continue;
                this.dependencies.add(bestRequiredFolder);
                this.dependenciesIDs.add(segmentID);
                continue;
            }
            if (path.length() <= 0 || !path.endsWith(JAR_EXTENSION)) continue;
            try {
                JarFile jarFile = new JarFile(path);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry nextElement = entries.nextElement();
                    String name = nextElement.getName();
                    if (nextElement.isDirectory() || !name.endsWith("emtl")) continue;
                    URI jarFileURI = URI.createFileURI((String)path);
                    URI entryURI = URI.createURI((String)name);
                    URI uri = URI.createURI((String)("jar:" + jarFileURI.toString() + "!/" + entryURI.toString()));
                    this.jarEmtlsURI.add(uri);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void registerPackages() {
        EPackage.Registry.INSTANCE.put((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)this.getOCLStdLibPackage());
    }

    protected EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }

    protected void registerResourceFactories() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlResourceFactoryImpl());
    }

    protected void registerLibraries() {
        CodeSource acceleoModel = MtlPackage.class.getProtectionDomain().getCodeSource();
        if (acceleoModel != null) {
            String libraryLocation = acceleoModel.getLocation().toString();
            if (libraryLocation.endsWith(JAR_EXTENSION)) {
                libraryLocation = "jar:" + libraryLocation + '!';
            }
            URL stdlib = MtlPackage.class.getResource("/model/mtlstdlib.ecore");
            URL resource = MtlPackage.class.getResource("/model/mtlnonstdlib.ecore");
            URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlstdlib.ecore"), URI.createURI((String)stdlib.toString()));
            URIConverter.URI_MAP.put(URI.createURI((String)"http://www.eclipse.org/acceleo/mtl/3.0/mtlnonstdlib.ecore"), URI.createURI((String)resource.toString()));
        } else {
            System.err.println("Coudln't retrieve location of plugin 'org.eclipse.acceleo.model'.");
        }
    }

    public void setBinaryResource(boolean binaryResource) {
        this.binaryResource = binaryResource;
    }

    public void setOutputFolder(String theOutputFolder) {
        this.outputFolder = new Path(theOutputFolder).toFile();
    }

    public void setTrimPosition(boolean trimPosition) {
        this.trimPosition = trimPosition;
    }

    public void doCompile(Monitor monitor) {
        this.compile(monitor);
    }

    protected void compile(Monitor monitor) {
        this.registerResourceFactories();
        this.registerPackages();
        this.registerLibraries();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            this.standaloneInit();
        }
        StringBuffer message = new StringBuffer();
        ArrayList<MTLFileInfo> fileInfos = new ArrayList<MTLFileInfo>();
        fileInfos.addAll(this.computeFileInfos(this.sourceFolder));
        ArrayList<AcceleoFile> acceleoFiles = new ArrayList<AcceleoFile>();
        ArrayList<URI> emtlAbsoluteURIs = new ArrayList<URI>();
        for (MTLFileInfo mtlFileInfo : fileInfos) {
            acceleoFiles.add(new AcceleoFile(mtlFileInfo.mtlFile, mtlFileInfo.fullModuleName));
            emtlAbsoluteURIs.add(mtlFileInfo.emtlAbsoluteURI);
        }
        ArrayList<URI> dependenciesURIs = new ArrayList<URI>();
        HashMap<URI, URI> mapURIs = new HashMap<URI, URI>();
        this.computeDependencies(dependenciesURIs, mapURIs);
        this.loadEcoreFiles();
        this.createOutputFiles(emtlAbsoluteURIs);
        AcceleoParser parser = new AcceleoParser(this.binaryResource, this.trimPosition);
        parser.parse(acceleoFiles, emtlAbsoluteURIs, dependenciesURIs, mapURIs, monitor);
        for (AcceleoFile acceleoFile : acceleoFiles) {
            List list;
            AcceleoParserProblems problems = parser.getProblems(acceleoFile);
            if (problems == null || (list = problems.getList()).isEmpty()) continue;
            message.append(acceleoFile.getMtlFile().getName());
            message.append('\n');
            for (AcceleoParserProblem problem : list) {
                message.append(problem.getLine());
                message.append(':');
                message.append(problem.getMessage());
                message.append('\n');
            }
            message.append('\n');
        }
        if (message.length() > 0) {
            String log = message.toString();
            throw new RuntimeException(log);
        }
    }

    private void standaloneInit() {
        Resource.Factory.Registry registry = Resource.Factory.Registry.INSTANCE;
        if (registry.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.binary") == null) {
            registry.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.binary", new EMtlBinaryResourceFactoryImpl());
        }
        if (registry.getContentTypeToFactoryMap().get("org.eclipse.acceleo.model.content.emtl.xmi") == null) {
            registry.getContentTypeToFactoryMap().put("org.eclipse.acceleo.model.content.emtl.xmi", new EMtlBinaryResourceFactoryImpl());
        }
        registry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        this.registerPackages();
    }

    protected List<MTLFileInfo> computeFileInfos(File theSourceFolder) {
        String file;
        ArrayList<MTLFileInfo> fileInfosOutput = new ArrayList<MTLFileInfo>();
        String inputPath = this.sourceFolder.getAbsolutePath();
        if (inputPath.startsWith(file = "file:")) {
            inputPath = inputPath.substring(file.length());
        }
        if (!theSourceFolder.exists()) {
            return fileInfosOutput;
        }
        String sourceFolderAbsolutePath = theSourceFolder.getAbsolutePath();
        ArrayList<File> mtlFiles = new ArrayList<File>();
        this.members(mtlFiles, theSourceFolder, "mtl");
        for (File mtlFile : mtlFiles) {
            String mtlFileAbsolutePath = mtlFile.getAbsolutePath();
            if (mtlFileAbsolutePath == null) continue;
            String relativePath = mtlFileAbsolutePath.startsWith(sourceFolderAbsolutePath) ? mtlFileAbsolutePath.substring(sourceFolderAbsolutePath.length()) : mtlFile.getName();
            URI emtlAbsoluteURI = null;
            if (this.outputFolder != null) {
                String outputPath = this.outputFolder.getAbsolutePath();
                if (outputPath.startsWith(file)) {
                    outputPath = outputPath.substring(file.length());
                }
                String temp = new Path(mtlFileAbsolutePath).removeFileExtension().addFileExtension("emtl").toString();
                int segments = new Path(temp).matchingFirstSegments((IPath)new Path(inputPath));
                IPath path = new Path(temp).removeFirstSegments(segments);
                IPath emtlPath = new Path(outputPath).append(path);
                emtlAbsoluteURI = URI.createFileURI((String)emtlPath.toString());
            } else {
                emtlAbsoluteURI = URI.createFileURI((String)new Path(inputPath).removeFileExtension().addFileExtension("emtl").toString());
            }
            MTLFileInfo fileInfo = new MTLFileInfo();
            fileInfo.mtlFile = mtlFile;
            fileInfo.emtlAbsoluteURI = emtlAbsoluteURI;
            fileInfo.fullModuleName = AcceleoFile.relativePathToFullModuleName((String)relativePath);
            fileInfosOutput.add(fileInfo);
        }
        return fileInfosOutput;
    }

    protected void members(List<File> filesOutput, File container, String extension) {
        File[] children;
        if (container != null && container.isDirectory() && (children = container.listFiles()) != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() && child.getName() != null && (extension == null || child.getName().endsWith(String.valueOf('.') + extension))) {
                    filesOutput.add(child);
                } else {
                    this.members(filesOutput, child, extension);
                }
                ++n2;
            }
        }
    }

    protected void computeDependencies(List<URI> dependenciesURIs, Map<URI, URI> mapURIs) {
        Iterator<String> identifiersIt = this.dependenciesIDs.iterator();
        Iterator<File> dependenciesIt = this.dependencies.iterator();
        while (dependenciesIt.hasNext() && identifiersIt.hasNext()) {
            File requiredFolder = dependenciesIt.next();
            String identifier = identifiersIt.next();
            if (requiredFolder == null || !requiredFolder.exists() || !requiredFolder.isDirectory()) continue;
            String requiredFolderAbsolutePath = requiredFolder.getAbsolutePath();
            ArrayList<File> emtlFiles = new ArrayList<File>();
            this.members(emtlFiles, requiredFolder, "emtl");
            for (File emtlFile : emtlFiles) {
                String emtlAbsolutePath = emtlFile.getAbsolutePath();
                URI emtlFileURI = URI.createFileURI((String)emtlAbsolutePath);
                dependenciesURIs.add(emtlFileURI);
                IPath relativePath = new Path(identifier).append(emtlAbsolutePath.substring(requiredFolderAbsolutePath.length()));
                mapURIs.put(emtlFileURI, URI.createPlatformPluginURI((String)relativePath.toString(), (boolean)false));
            }
        }
    }

    protected void computeJarDependencies(List<URI> dependenciesURIs, Map<URI, URI> mapURIs) {
        for (URI uri : this.jarEmtlsURI) {
            String uriStr = uri.toString();
            int i = uriStr.indexOf("!/");
            if (i <= 0) continue;
            String fileURI = uriStr.substring(i + 2);
            String authority = uri.authority();
            int lastIndexOf = authority.lastIndexOf("/");
            int indexOf = authority.lastIndexOf("_");
            if (lastIndexOf > 0 && indexOf > 0) {
                authority = authority.substring(lastIndexOf, indexOf);
            }
            URI platformPluginURI = URI.createPlatformPluginURI((String)(String.valueOf(authority) + "/" + fileURI), (boolean)true);
            mapURIs.put(uri, platformPluginURI);
            dependenciesURIs.add(uri);
        }
    }

    protected void loadEcoreFiles() {
        for (File requiredFolder : this.dependencies) {
            if (requiredFolder == null || !requiredFolder.exists() || !requiredFolder.isDirectory()) continue;
            ArrayList<File> ecoreFiles = new ArrayList<File>();
            this.members(ecoreFiles, requiredFolder, "ecore");
            for (File ecoreFile : ecoreFiles) {
                URI ecoreURI = URI.createFileURI((String)ecoreFile.getAbsolutePath());
                AcceleoPackageRegistry.INSTANCE.registerEcorePackages(ecoreURI.toString(), AcceleoPackageRegistry.DYNAMIC_METAMODEL_RESOURCE_SET);
            }
        }
    }

    protected void createOutputFiles(List<URI> emtlAbsoluteURIs) {
        for (URI uri : emtlAbsoluteURIs) {
            String file;
            String tmpUri = uri.toString();
            if (tmpUri.startsWith(file = "file:")) {
                tmpUri = tmpUri.substring(file.length());
            }
            if (new File(tmpUri).getParentFile().exists()) continue;
            new File(tmpUri).getParentFile().mkdirs();
        }
    }

    protected final class MTLFileInfo {
        protected File mtlFile;
        protected URI emtlAbsoluteURI;
        protected String fullModuleName;

        protected MTLFileInfo() {
        }
    }
}

