/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.edit.part;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.appearance.helper.NameLabelIconHelper;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.edit.part.AbstractElementLabelEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.swt.graphics.Image;

public class FlowPortAffixedLabelNameEditPart
extends AbstractElementLabelEditPart
implements IBorderItemEditPart {
    private final ILabelProvider labelProvider;

    public FlowPortAffixedLabelNameEditPart(View view) {
        super(view);
        this.addSnapBackLocation();
        this.labelProvider = Activator.getInstance().getLabelProvider();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
    }

    public IBorderItemLocator getBorderItemLocator() {
        IFigure parentFigure = this.getFigure().getParent();
        if (parentFigure != null && parentFigure.getLayoutManager() != null) {
            Object constraint = parentFigure.getLayoutManager().getConstraint(this.getFigure());
            return (IBorderItemLocator)constraint;
        }
        return null;
    }

    public void refreshBounds() {
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        IBorderItemLocator locator = this.getBorderItemLocator();
        locator.setConstraint(new Rectangle(x, y, width, height));
        this.getFigure().getParent().setConstraint(this.getFigure(), (Object)locator);
    }

    @Override
    protected Image getLabelIcon() {
        EObject parserElement = this.getParserElement();
        if (parserElement == null) {
            return null;
        }
        List views = DiagramEditPartsUtil.findViews((EObject)parserElement, (EditPartViewer)this.getViewer());
        for (View view : views) {
            if (!NameLabelIconHelper.showLabelIcon((EModelElement)view)) continue;
            return this.labelProvider.getImage((Object)parserElement);
        }
        return null;
    }

    @Override
    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        return new PapyrusWrappingLabel();
    }

    @Override
    public String getLabelRole() {
        return "Label";
    }

    @Override
    public String getIconPathRole() {
        return "";
    }
}

