/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.spi.security;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.security.Access;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.PermissionFilter;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.internal.security.bundle.OM;
import org.eclipse.emf.cdo.server.security.ISecurityManager;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.ProductCreationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomeFolderHandler
implements InternalSecurityManager.CommitHandler2 {
    public static final String DEFAULT_HOME_FOLDER = "/home";
    private static final SecurityFactory SF = SecurityFactory.eINSTANCE;
    private final String homeFolder;
    private ExecutorService executorService;

    public HomeFolderHandler(String homeFolder) {
        this.homeFolder = homeFolder == null || homeFolder.length() == 0 ? DEFAULT_HOME_FOLDER : homeFolder;
    }

    public HomeFolderHandler() {
        this(null);
    }

    public String getHomeFolder() {
        return this.homeFolder;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public void init(InternalSecurityManager securityManager, boolean firstTime) {
        EList users;
        if (firstTime && !(users = securityManager.getRealm().getAllUsers()).isEmpty()) {
            BasicEList userIDs = new BasicEList();
            for (User user : users) {
                userIDs.add(user.getId());
            }
            this.handleUsers(securityManager, (List<String>)userIDs, true);
        }
    }

    protected void initRole(Role role) {
        role.getPermissions().add((Object)SF.createFilterPermission(Access.WRITE, new PermissionFilter[]{SF.createResourceFilter(String.valueOf(this.homeFolder) + "/${user}", PatternStyle.TREE, false)}));
        role.getPermissions().add((Object)SF.createFilterPermission(Access.READ, new PermissionFilter[]{SF.createResourceFilter(this.homeFolder, PatternStyle.EXACT, true)}));
    }

    @Override
    public void handleCommit(InternalSecurityManager securityManager, IStoreAccessor.CommitContext commitContext, User user) {
    }

    @Override
    public void handleCommitted(final InternalSecurityManager securityManager, IStoreAccessor.CommitContext commitContext) {
        List userIDs = null;
        InternalCDORevision[] newObjects = commitContext.getNewObjects();
        int i = 0;
        while (i < newObjects.length) {
            String userID;
            InternalCDORevision newObject = newObjects[i];
            EClass eClass = newObject.getEClass();
            if (eClass == SecurityPackage.Literals.USER && (userID = (String)newObject.getValue((EStructuralFeature)SecurityPackage.Literals.ASSIGNEE__ID)) != null) {
                if (userIDs == null) {
                    userIDs = new BasicEList();
                }
                userIDs.add(userID);
            }
            ++i;
        }
        if (userIDs != null) {
            final List list = userIDs;
            long commitTime = commitContext.getBranchPoint().getTimeStamp();
            CDOView view = securityManager.getRealm().cdoView();
            view.runAfterUpdate(commitTime, new Runnable(){

                public void run() {
                    HomeFolderHandler.this.handleUsers(securityManager, list, false);
                }
            });
        }
    }

    protected void handleUsers(final InternalSecurityManager securityManager, final List<String> userIDs, final boolean init) {
        this.executorService.submit(new Runnable(){

            public void run() {
                securityManager.modify(new ISecurityManager.RealmOperation(){

                    public void execute(Realm realm) {
                        Role role;
                        String roleID = "Home Folder " + HomeFolderHandler.this.homeFolder;
                        if (init) {
                            role = realm.addRole(roleID);
                            HomeFolderHandler.this.initRole(role);
                        } else {
                            role = realm.getRole(roleID);
                            if (role == null) {
                                OM.LOG.warn("Role '" + roleID + "' not found in " + HomeFolderHandler.this);
                                return;
                            }
                        }
                        CDOTransaction transaction = (CDOTransaction)realm.cdoView();
                        for (String userID : userIDs) {
                            try {
                                User user = realm.getUser(userID);
                                if (user == null) {
                                    OM.LOG.warn("User '" + userID + "' not found in " + HomeFolderHandler.this);
                                    continue;
                                }
                                HomeFolderHandler.this.handleUser(transaction, realm, role, user);
                            }
                            catch (Exception ex) {
                                OM.LOG.error((Throwable)ex);
                            }
                        }
                    }
                });
            }
        });
    }

    protected void handleUser(CDOTransaction transaction, Realm realm, Role role, User user) throws Exception {
        EList roles = user.getRoles();
        roles.add((Object)role);
        String path = String.valueOf(this.getHomeFolder()) + "/" + user.getId();
        transaction.getOrCreateResourceFolder(path);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.homeFolder + "]";
    }

    public static class Factory
    extends InternalSecurityManager.CommitHandler.Factory
    implements IManagedContainer.ContainerAware {
        private IManagedContainer container;

        public Factory() {
            super("home");
        }

        public void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }

        public InternalSecurityManager.CommitHandler create(String homeFolder) throws ProductCreationException {
            ExecutorService executorService = ExecutorServiceFactory.get((IManagedContainer)this.container);
            HomeFolderHandler handler = new HomeFolderHandler(homeFolder);
            handler.setExecutorService(executorService);
            return handler;
        }
    }
}

