/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.alf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AssignmentOperator implements Enumerator
{
    ASSIGN(0, "ASSIGN", "="),
    PLUSASSIGN(1, "PLUSASSIGN", "+="),
    MINUSASSIGN(2, "MINUSASSIGN", "-="),
    MULTASSIGN(3, "MULTASSIGN", "*="),
    MODASSIGN(4, "MODASSIGN", "%="),
    DIVASSIGN(5, "DIVASSIGN", "/="),
    ANDASSIGN(6, "ANDASSIGN", "&="),
    ORASSIGN(7, "ORASSIGN", "|="),
    XORASSIGN(8, "XORASSIGN", "^="),
    LSHIFTASSIGN(9, "LSHIFTASSIGN", "<<="),
    RSHIFTASSIGN(10, "RSHIFTASSIGN", ">>="),
    URSHIFTASSIGN(11, "URSHIFTASSIGN", ">>>=");

    public static final int ASSIGN_VALUE = 0;
    public static final int PLUSASSIGN_VALUE = 1;
    public static final int MINUSASSIGN_VALUE = 2;
    public static final int MULTASSIGN_VALUE = 3;
    public static final int MODASSIGN_VALUE = 4;
    public static final int DIVASSIGN_VALUE = 5;
    public static final int ANDASSIGN_VALUE = 6;
    public static final int ORASSIGN_VALUE = 7;
    public static final int XORASSIGN_VALUE = 8;
    public static final int LSHIFTASSIGN_VALUE = 9;
    public static final int RSHIFTASSIGN_VALUE = 10;
    public static final int URSHIFTASSIGN_VALUE = 11;
    private static final AssignmentOperator[] VALUES_ARRAY;
    public static final List<AssignmentOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssignmentOperator[]{ASSIGN, PLUSASSIGN, MINUSASSIGN, MULTASSIGN, MODASSIGN, DIVASSIGN, ANDASSIGN, ORASSIGN, XORASSIGN, LSHIFTASSIGN, RSHIFTASSIGN, URSHIFTASSIGN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssignmentOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssignmentOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssignmentOperator get(int value) {
        switch (value) {
            case 0: {
                return ASSIGN;
            }
            case 1: {
                return PLUSASSIGN;
            }
            case 2: {
                return MINUSASSIGN;
            }
            case 3: {
                return MULTASSIGN;
            }
            case 4: {
                return MODASSIGN;
            }
            case 5: {
                return DIVASSIGN;
            }
            case 6: {
                return ANDASSIGN;
            }
            case 7: {
                return ORASSIGN;
            }
            case 8: {
                return XORASSIGN;
            }
            case 9: {
                return LSHIFTASSIGN;
            }
            case 10: {
                return RSHIFTASSIGN;
            }
            case 11: {
                return URSHIFTASSIGN;
            }
        }
        return null;
    }

    private AssignmentOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

