/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.alf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AnnotationKind implements Enumerator
{
    ISOLATED(0, "ISOLATED", "isolated"),
    DETERMINED(1, "DETERMINED", "determined"),
    ASSURED(2, "ASSURED", "assured"),
    PARALLEL(3, "PARALLEL", "parallel");

    public static final int ISOLATED_VALUE = 0;
    public static final int DETERMINED_VALUE = 1;
    public static final int ASSURED_VALUE = 2;
    public static final int PARALLEL_VALUE = 3;
    private static final AnnotationKind[] VALUES_ARRAY;
    public static final List<AnnotationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AnnotationKind[]{ISOLATED, DETERMINED, ASSURED, PARALLEL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AnnotationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AnnotationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AnnotationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AnnotationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AnnotationKind get(int value) {
        switch (value) {
            case 0: {
                return ISOLATED;
            }
            case 1: {
                return DETERMINED;
            }
            case 2: {
                return ASSURED;
            }
            case 3: {
                return PARALLEL;
            }
        }
        return null;
    }

    private AnnotationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

