/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.synchronizeview.customization;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.uml.diagram.synchronizeview.customization.ISynchroSemanticChild;
import org.eclipse.papyrus.uml.diagram.synchronizeview.customization.SemanticChild;
import org.osgi.framework.Bundle;

public class SynchroSemanticChildRegistry {
    private static final String SEMANTICCHILD_EXTENSION_ID = "org.eclipse.papyrus.uml.diagram.synchronizeview.semanticchild";
    private static final String EDITPART = "editPart";
    private static final String GET_SEMANTIC_CHILDREN = "getSemanticChildren";
    private static final String PRIORITY = "priority";
    protected HashMap<Class<? extends EditPart>, SemanticChild> semanticMap = new HashMap();
    protected static SynchroSemanticChildRegistry eInstance = null;

    public static SynchroSemanticChildRegistry getInstance() {
        if (eInstance == null) {
            eInstance = new SynchroSemanticChildRegistry();
        }
        return eInstance;
    }

    public SynchroSemanticChildRegistry() {
        this.init();
    }

    public void init() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEMANTICCHILD_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            SemanticChild semanticChild = this.createSemanticChild(configElements[i]);
            if (this.semanticMap.get(semanticChild.getEditPart()) != null) {
                if (this.semanticMap.get(semanticChild.getEditPart()).getPriority() <= semanticChild.getPriority()) {
                    this.semanticMap.remove(semanticChild.getEditPart());
                    this.semanticMap.put(semanticChild.getEditPart(), semanticChild);
                }
            } else {
                this.semanticMap.put(semanticChild.getEditPart(), semanticChild);
            }
            ++i;
        }
    }

    protected SemanticChild createSemanticChild(IConfigurationElement element) {
        Class<? extends EditPart> editPart = null;
        ISynchroSemanticChild synchroSemanticChild = null;
        int priority = 0;
        SemanticChild semanticChild = null;
        try {
            editPart = SynchroSemanticChildRegistry.LoadExtension(element, element.getAttribute(EDITPART));
            synchroSemanticChild = (ISynchroSemanticChild)SynchroSemanticChildRegistry.createExtension(element, element.getAttribute(GET_SEMANTIC_CHILDREN));
            if (element.getAttribute(PRIORITY) != null) {
                priority = Integer.getInteger(element.getAttribute(PRIORITY));
            }
            semanticChild = new SemanticChild(editPart, synchroSemanticChild, priority);
        }
        catch (Exception e) {
            Activator.log.error(element + " can not be loaded ", (Throwable)e);
        }
        return semanticChild;
    }

    protected static Class<? extends EditPart> LoadExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            return clazz;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }

    protected static Object createExtension(IConfigurationElement element, String classAttribute) throws Exception {
        try {
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            Class clazz = extensionBundle.loadClass(classAttribute);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new Exception("unable to create Extension" + e);
        }
    }

    public ISynchroSemanticChild getSynchroSemanticChild(Class<? extends EditPart> editPart) {
        if (this.semanticMap.get(editPart) != null) {
            return this.semanticMap.get(editPart).getSynchroSemanticChild();
        }
        return null;
    }
}

