/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManager;
import org.eclipse.emf.facet.custom.core.internal.exception.CustomizationCatalogRuntimeException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationCatalog;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.customizationcatalog.CustomizationcatalogFactory;
import org.eclipse.emf.facet.util.emf.catalog.CatalogSet;
import org.eclipse.emf.facet.util.emf.core.ICatalogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationCatalogManager
implements ICustomizationCatalogManager,
ICatalogManager {
    private final CustomizationCatalog catalog = CustomizationcatalogFactory.eINSTANCE.createCustomizationCatalog();

    public boolean canBeManaged(EObject root) {
        return root instanceof Customization;
    }

    public void manage(EObject root) {
        if (!(root instanceof Customization)) {
            throw new CustomizationCatalogRuntimeException("Only customizations (and aggregates) must be stored in the customization catalog");
        }
        Customization customization = (Customization)root;
        this.catalog.getInstalledEntries().add((Object)customization);
    }

    public void setCatalogSet(CatalogSet catalogSet) {
        catalogSet.getCatalogs().add((Object)this.catalog);
    }

    public List<Customization> getCustomizationsByName(String name) {
        ArrayList<Customization> result = new ArrayList<Customization>();
        for (EObject eObject : this.catalog.getInstalledEntries()) {
            if (eObject instanceof Customization) {
                Customization customization = (Customization)eObject;
                if (!name.equals(customization.getName())) continue;
                result.add(customization);
                continue;
            }
            throw new RuntimeException("Only customizations (and aggregates) must be stored in the customization catalog");
        }
        return result;
    }

    @Override
    public void registerCustomization(Customization customization) {
        this.catalog.getInstalledEntries().add((Object)customization);
    }

    @Override
    public List<Customization> getCustomizationsApplicableOn(Collection<EObject> eObjects) {
        return null;
    }

    @Override
    public List<Customization> getRegisteredCustomizations() {
        ArrayList<Customization> result = new ArrayList<Customization>();
        for (EObject eObject : this.catalog.getInstalledEntries()) {
            if (eObject instanceof Customization) {
                Customization customization = (Customization)eObject;
                result.add(customization);
                continue;
            }
            throw new RuntimeException("Only customizations (and aggregates) must be stored in the customization catalog");
        }
        return Collections.unmodifiableList(result);
    }
}

