/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.tools.internal.command.SortDLinesCommand;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;

public class SortLinesByColumnAction
extends Action {
    private static final String DEFAULT_NAME = "Sort by";
    private static DColumn sortedBy;
    private static int sortDirection;
    private final TransactionalEditingDomain domain;
    private DColumn column;
    private DTable table;

    static {
        sortDirection = 0;
    }

    public SortLinesByColumnAction(TransactionalEditingDomain domain) {
        super(DEFAULT_NAME, DTableViewerManager.getImageRegistry().getDescriptor("table/sortByColumn"));
        this.domain = domain;
    }

    public void run() {
        super.run();
        if (sortedBy != null && sortedBy.equals(this.column) || sortedBy == null && this.column == null) {
            sortDirection = sortDirection == 128 ? 1024 : 128;
        } else {
            sortDirection = 128;
            sortedBy = this.column;
        }
        SortDLinesCommand sortDLinesCmd = new SortDLinesCommand(this.domain, this.table, sortedBy, sortDirection);
        this.domain.getCommandStack().execute((Command)sortDLinesCmd);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setColumn(DColumn column) {
        this.column = column;
        if (column != null) {
            this.setTable(TableHelper.getTable((EObject)column));
        }
    }

    public void setTable(DTable table) {
        this.table = table;
    }
}

