/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;

public class RefreshAction
extends Action {
    private static final String DEFAULT_NAME = "Refresh table";
    AbstractDTableEditor tableEditor;

    public RefreshAction(AbstractDTableEditor tableEditor) {
        super(DEFAULT_NAME, DTableViewerManager.getImageRegistry().getDescriptor("table/refresh"));
        this.tableEditor = tableEditor;
    }

    public void run() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                TransactionalEditingDomain domain = RefreshAction.this.tableEditor.getEditingDomain();
                domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{RefreshAction.this.tableEditor.getTableModel()}));
            }
        };
        Shell activeShell = this.tableEditor.getSite().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            try {
                this.tableEditor.enablePropertiesUpdate(false);
                RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)this.tableEditor.getTableModel());
                monitorDialog.run(true, false, op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)"Error", (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error("Error while refreshing table", (Throwable)e);
                this.tableEditor.enablePropertiesUpdate(true);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Cancelled", (String)e.getMessage());
                this.tableEditor.enablePropertiesUpdate(true);
            }
        }
        finally {
            this.tableEditor.enablePropertiesUpdate(true);
        }
    }
}

