/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractHideRevealAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableLineLabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class HideRevealLinesAction
extends AbstractHideRevealAction<DLine> {
    private static final String DIALOG_TITLE = "Hide/Show table lines";
    private static final String DIALOG_MESSAGE = "Uncheck lines to hide them:";
    private static final String ACTION_LABEL = "Hide/Show lines...";
    private final TreeViewer treeViewer;

    public HideRevealLinesAction(DTable dTable, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory, TreeViewer treeViewer) {
        super(dTable, ACTION_LABEL, DTableViewerManager.getImageRegistry().getDescriptor("table/hideReveal"), editingDomain, tableCommandFactory);
        this.treeViewer = treeViewer;
    }

    private ITreeContentProvider getContentProvider() {
        return new DLineContentProvider();
    }

    private ILabelProvider getLabelProvider() {
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        return new DTableLineLabelProvider(decorator);
    }

    @Override
    protected SelectionDialog createSelectionDialog() {
        CheckedTreeSelectionDialog dlg = new CheckedTreeSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.getLabelProvider(), this.getContentProvider());
        dlg.setInput((Object)this.getTable().getLines());
        dlg.setExpandedElements(this.treeViewer.getExpandedElements());
        return dlg;
    }

    @Override
    protected List<DLine> getAllElements() {
        List<DLine> result = this.getAllLines((List<DLine>)this.getTable().getLines());
        return result;
    }

    private List<DLine> getAllLines(List<DLine> lines) {
        ArrayList result = Lists.newArrayList();
        for (DLine dLine : lines) {
            result.add(dLine);
            result.addAll(this.getAllLines((List<DLine>)dLine.getLines()));
        }
        return result;
    }

    @Override
    protected Collection<DLine> getInitialVisibleElements() {
        return Collections2.filter(this.getAllElements(), (Predicate)new Predicate<DLine>(){

            public boolean apply(DLine input) {
                return input.isVisible();
            }
        });
    }

    @Override
    protected String getSetVisibleMethodName() {
        return TablePackage.eINSTANCE.getDLine_Visible().getName();
    }

    @Override
    protected String getMessage() {
        return DIALOG_MESSAGE;
    }

    @Override
    protected String getTitle() {
        return DIALOG_TITLE;
    }

    @Override
    protected boolean isVisibleElement(DLine element) {
        return element.isVisible();
    }

    private static final class DLineContentProvider
    implements ITreeContentProvider {
        private DLineContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EList) {
                EList visibleLines = (EList)inputElement;
                return visibleLines.toArray(new DLine[visibleLines.size()]);
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = null;
            if (parentElement instanceof DLine) {
                EList visibleLines = ((DLine)parentElement).getLines();
                result = visibleLines.toArray();
            }
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof DLine) {
                DLine line = (DLine)element;
                return line.eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }
    }
}

