/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.command.CreateColumnCommandFromToolCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreateTargetColumnAction
extends AbstractTargetColumnAction {
    DTable table;

    public CreateTargetColumnAction(CreateTool createTool, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(new IdentifiedElementQuery((IdentifiedElement)createTool).getLabel(), DTableViewerManager.getImageRegistry().getDescriptor("table/newColumn"), editingDomain, tableCommandFactory, (TableTool)createTool);
    }

    public void run() {
        super.run();
        this.getEditingDomain().getCommandStack().execute((Command)new CreateColumnCommandFromToolCommand(this.getEditingDomain(), this.getText(), this.getColumn(), this.table, this.tableCommandFactory, this.getCreateTool()));
    }

    @Override
    public boolean canExecute() {
        boolean canExecute = true;
        if (this.getCreateTool() != null) {
            if (this.getCreateTool().getFirstModelOperation() == null) {
                canExecute = false;
            } else if (this.getCreateTool().getPrecondition() != null && !StringUtil.isEmpty((String)this.getCreateTool().getPrecondition().trim())) {
                IInterpreter interpreter;
                if (this.getColumn() != null) {
                    interpreter = InterpreterUtil.getInterpreter((EObject)this.getColumn().getTarget());
                    interpreter.setVariable("root", (Object)TableHelper.getTable((EObject)this.getColumn()).getTarget());
                    interpreter.setVariable("element", (Object)this.getColumn().getTarget());
                    interpreter.setVariable("container", (Object)((DTable)this.getColumn().eContainer()).getTarget());
                } else {
                    interpreter = InterpreterUtil.getInterpreter((EObject)this.getTable().getTarget());
                    interpreter.setVariable("root", (Object)this.getTable().getTarget());
                    interpreter.setVariable("element", (Object)this.getTable().getTarget());
                    interpreter.setVariable("container", null);
                }
                try {
                    canExecute = interpreter.evaluateBoolean(this.getColumn().getTarget(), this.getCreateTool().getPrecondition());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this.getCreateTool(), (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
                }
                interpreter.unSetVariable("root");
                interpreter.unSetVariable("element");
                interpreter.unSetVariable("container");
            }
        }
        return canExecute;
    }

    private CreateTool getCreateTool() {
        CreateTool tool = null;
        TableTool tableTool = this.getTool();
        if (tableTool instanceof CreateTool) {
            tool = (CreateTool)tableTool;
        }
        return tool;
    }

    public DTable getTable() {
        return this.table;
    }

    public void setTable(DTable table) {
        this.table = table;
    }
}

