/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractToolAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public abstract class AbstractEditorCreateMenuAction<T extends AbstractToolAction>
extends Action
implements IMenuCreator {
    private final MenuManager menuManager = new MenuManager();
    private T lastCreateAction;
    private final List<T> createActionsForTable = Lists.newArrayList();
    private final Listener menuItemListener = new Listener(){

        public void handleEvent(Event event) {
            if (13 == event.type && !event.widget.isDisposed()) {
                ActionContributionItem item = (ActionContributionItem)event.widget.getData();
                AbstractEditorCreateMenuAction.this.setLastAction((AbstractToolAction)item.getAction());
            }
        }
    };

    protected AbstractEditorCreateMenuAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setMenuCreator(this);
        this.setEnabled(false);
    }

    public void run() {
        if (this.lastCreateAction != null && this.lastCreateAction.isEnabled()) {
            this.lastCreateAction.run();
        }
    }

    public void addActionToMenu(Action action) {
        ActionContributionItem contribution = new ActionContributionItem((IAction)action);
        this.menuManager.add((IContributionItem)contribution);
    }

    public void dispose() {
        if (this.menuManager.getMenu() != null) {
            MenuItem[] menuItems;
            MenuItem[] menuItemArray = menuItems = this.menuManager.getMenu().getItems();
            int n = menuItems.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem menuItem = menuItemArray[n2];
                if (menuItem.getStyle() != 2) {
                    menuItem.removeListener(13, this.menuItemListener);
                }
                ++n2;
            }
            this.menuManager.getMenu().dispose();
        }
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        MenuItem[] menuItems;
        if (this.menuManager.getMenu() == null) {
            this.menuManager.createContextMenu(parent);
            this.update();
        }
        MenuItem[] menuItemArray = menuItems = this.menuManager.getMenu().getItems();
        int n = menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            if (menuItem.getStyle() != 2) {
                menuItem.addListener(13, this.menuItemListener);
            }
            ++n2;
        }
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void update(List<AbstractToolAction> actions) {
        this.getCreateActionsForTable().clear();
        this.menuManager.removeAll();
        for (AbstractToolAction toolAction : this.filter(actions)) {
            this.getCreateActionsForTable().add((T)((Object)toolAction));
        }
        this.update();
    }

    protected abstract List<T> filter(List<AbstractToolAction> var1);

    protected void update() {
        this.setEnabled(!this.getCreateActionsForTable().isEmpty());
        this.menuManager.removeAll();
        for (AbstractToolAction createAction : this.getCreateActionsForTable()) {
            if (!createAction.canExecute()) continue;
            this.menuManager.add((IAction)createAction);
        }
    }

    public void setLastAction(T createAction) {
        this.lastCreateAction = createAction;
    }

    protected List<T> getCreateActionsForTable() {
        return this.createActionsForTable;
    }
}

