/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.listeners.DLineExpansionChecker;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnHeaderLabelProvider;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.ui.tools.internal.editor.DTableColumnViewerEditorActivationStrategy;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DTableTreeViewer
extends AbstractDTreeViewer {
    private DCell selectedCell;
    private DTableViewerManager manager;
    private Character firstEditionCharacter;
    private DLineExpansionChecker dLineExpansionChecker;

    public DTableTreeViewer(Composite parent, int style, DTableViewerManager manager) {
        super(parent, style);
        this.manager = manager;
        this.dLineExpansionChecker.setPermissionAuthority(manager.getAccessor().getPermissionAuthority());
        this.dLineExpansionChecker.setDTableViewerManager(manager);
    }

    protected void hookControl(Control control) {
        this.dLineExpansionChecker = new DLineExpansionChecker(control);
        super.hookControl(control);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (input instanceof DTable) {
            TableHelper.fillCache((DTable)((DTable)input));
        }
        try {
            super.inputChanged(input, oldInput);
        }
        finally {
            TableHelper.clearCache();
        }
    }

    protected void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        if (event.eventType == 1 && !DTableColumnViewerEditorActivationStrategy.isActivationKey((ColumnViewerEditorActivationEvent)event) && Character.isLetterOrDigit(event.character)) {
            this.setFirstEditionCharacter(Character.valueOf(event.character));
        } else {
            this.setFirstEditionCharacter(null);
        }
        super.triggerEditorActivationEvent(event);
        if (event.getSource() instanceof ViewerCell && ((ViewerCell)event.getSource()).getElement() instanceof DLine) {
            Tree tree = (Tree)((ViewerCell)event.getSource()).getViewerRow().getControl();
            DLine line = (DLine)((ViewerCell)event.getSource()).getElement();
            int columnIndexSortedInSwtTable = ((ViewerCell)event.getSource()).getColumnIndex();
            int[] order = tree.getColumnOrder();
            int columnIndexDisplayInSwtTable = -1;
            int i = 0;
            while (i < order.length && columnIndexDisplayInSwtTable == -1) {
                if (order[i] == columnIndexSortedInSwtTable) {
                    columnIndexDisplayInSwtTable = i;
                }
                ++i;
            }
            int columnIndexInTable = columnIndexDisplayInSwtTable - 1;
            Option optionalCell = Options.newNone();
            if (columnIndexInTable != -1) {
                DColumn column = (DColumn)TableHelper.getTable((EObject)line).getColumns().get(columnIndexInTable);
                optionalCell = TableHelper.getCell((DLine)line, (DColumn)column);
            }
            if (!optionalCell.some()) {
                this.selectedCell = null;
                if (event.eventType == 1 && (event.keyCode == 0x1000003 || event.keyCode == 0x1000004)) {
                    this.updateSelection((ISelection)new StructuredSelection((Object)line));
                }
            } else {
                this.selectedCell = (DCell)optionalCell.get();
                if (event.eventType == 1 && (event.keyCode == 0x1000003 || event.keyCode == 0x1000004)) {
                    this.updateSelection((ISelection)new StructuredSelection((Object)this.selectedCell));
                }
            }
        } else {
            this.selectedCell = null;
        }
    }

    protected void updateSelection(ISelection selection) {
        if (this.selectedCell != null) {
            StructuredSelection cellSelection = new StructuredSelection((Object)this.selectedCell);
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)cellSelection);
            this.fireSelectionChanged(event);
        } else {
            super.updateSelection(selection);
        }
    }

    public void refreshItem(final Item item, final DRepresentationElement dRepresentationElement) {
        if (item instanceof TreeColumn) {
            this.preservingSelection(new Runnable(){

                @Override
                public void run() {
                    TreeColumn treeColumn = (TreeColumn)item;
                    DTableColumnHeaderLabelProvider dTableColumnHeaderLabelProvider = new DTableColumnHeaderLabelProvider();
                    String text = dTableColumnHeaderLabelProvider.getText(dRepresentationElement);
                    treeColumn.setText(text);
                    Image image = dTableColumnHeaderLabelProvider.getImage(dRepresentationElement);
                    treeColumn.setImage(image);
                }
            });
        } else {
            super.refreshItem(item, dRepresentationElement);
        }
    }

    public void addNewColumn(DTargetColumn newColumn) {
        this.manager.addNewColumn((DColumn)newColumn, -1, true);
    }

    public void addNewColumn(int position, DColumn newColumn) {
        this.manager.addNewColumn(newColumn, position, true);
    }

    public void removeOldColumn(DColumn oldColumn) {
        this.manager.removeOldColumn(oldColumn);
    }

    public void removeOldColumn(int position) {
        this.manager.removeOldColumn(position);
    }

    public boolean isSameTable(DTable table) {
        return this.manager.isSameTable(table);
    }

    public void refreshColumns() {
        this.manager.refreshColumns();
    }

    public void fillMenu() {
        this.manager.fillMenu();
    }

    public void setDescriptionFileChanged(boolean modified) {
        this.manager.setDescriptionFileChanged(modified);
    }

    public Character getFirstEditionCharacter() {
        return this.firstEditionCharacter;
    }

    protected void setFirstEditionCharacter(Character firstEditionCharacter) {
        this.firstEditionCharacter = firstEditionCharacter;
    }

    protected void handleDispose(DisposeEvent event) {
        this.dLineExpansionChecker.dispose();
        super.handleDispose(event);
    }
}

