/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusConfiguration;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;

public class WeightedConfiguration {
    private static final String EXTENSION_ID = "org.eclipse.papyrus.infra.viewpoints.policy.custom";
    private String uri;
    private int priority;
    private PapyrusConfiguration config;

    public String getURI() {
        return this.uri;
    }

    public PapyrusConfiguration getConfiguration() {
        if (this.config == null) {
            this.config = PolicyChecker.loadConfigurationFrom(this.uri);
        }
        return this.config;
    }

    private WeightedConfiguration(String plugin, IConfigurationElement config) {
        this.uri = config.getAttribute("file");
        if (!this.uri.startsWith("platform:/plugin/")) {
            this.uri = "platform:/plugin/" + plugin + "/" + this.uri;
        }
        try {
            this.priority = Integer.parseInt(config.getAttribute("priority"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static WeightedConfiguration getTopConfiguration() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_ID);
        IExtension[] extensions = point.getExtensions();
        ArrayList<WeightedConfiguration> configs = new ArrayList<WeightedConfiguration>();
        int i = 0;
        while (i != extensions.length) {
            String plugin = extensions[i].getContributor().getName();
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j != elements.length) {
                if (elements[j].getName().equals("configuration")) {
                    configs.add(new WeightedConfiguration(plugin, elements[j]));
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(configs, new Comparator());
        if (configs.size() == 0) {
            return null;
        }
        return (WeightedConfiguration)configs.get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comparator
    implements java.util.Comparator<WeightedConfiguration>,
    Serializable {
        private static final long serialVersionUID = 9025582514350440832L;

        private Comparator() {
        }

        @Override
        public int compare(WeightedConfiguration o1, WeightedConfiguration o2) {
            return o2.priority - o1.priority;
        }
    }
}

