/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.constraints.Activator;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.constraints.Constraint;
import org.eclipse.papyrus.infra.constraints.runtime.ConstraintFactory;
import org.eclipse.papyrus.infra.constraints.runtime.DefaultConstraintEngine;
import org.eclipse.papyrus.infra.viewpoints.configuration.ModelRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRuleConstraintEngine
extends DefaultConstraintEngine<ModelRule> {
    protected final Map<ModelRule, List<Constraint>> modelRule2Constraints = new HashMap<ModelRule, List<Constraint>>();
    private static ModelRuleConstraintEngine instance;

    public void refresh() {
        this.modelRule2Constraints.clear();
        this.fireConstraintsChanged();
    }

    public boolean matchesRule(ModelRule rule, EObject element) {
        StructuredSelection selection = new StructuredSelection((Object)element);
        List<Constraint> constraints = this.getConstraintsFor(rule);
        if (constraints == null || constraints.size() == 0) {
            return true;
        }
        for (Constraint c : constraints) {
            try {
                if (c.match((IStructuredSelection)selection)) continue;
                return false;
            }
            catch (Throwable ex) {
                Activator.log.error(ex);
            }
        }
        return true;
    }

    protected List<Constraint> getConstraintsFor(ModelRule rule) {
        if (!this.modelRule2Constraints.containsKey(rule)) {
            List<Constraint> constraints = this.initializeConstraints(rule);
            this.modelRule2Constraints.put(rule, constraints);
        }
        return this.modelRule2Constraints.get(rule);
    }

    protected List<Constraint> initializeConstraints(ModelRule rule) {
        EList descriptors = rule.getConstraints();
        if (descriptors == null || descriptors.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (ConstraintDescriptor descriptor : descriptors) {
            try {
                Constraint constraint = ConstraintFactory.getInstance().createFromModel(descriptor);
                if (constraint == null) continue;
                constraints.add(constraint);
            }
            catch (Throwable e) {
                Activator.log.error(e);
            }
        }
        return constraints;
    }

    public static synchronized ModelRuleConstraintEngine getInstance() {
        if (instance == null) {
            instance = new ModelRuleConstraintEngine();
        }
        return instance;
    }
}

