/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ocl.examples.xtext.base.ui.Activator;
import org.eclipse.ocl.examples.xtext.base.ui.messages.BaseUIMessages;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileDialog;
import org.eclipse.ocl.examples.xtext.base.ui.wizards.AbstractFileNewWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class AbstractFileNewWizardPage
extends WizardPage
implements Listener {
    @NonNull
    protected final AbstractFileNewWizard wizard;
    @Nullable
    protected final IResource initialSelection;
    private IFile newFile;
    private AbstractFileDialog dialog;

    public AbstractFileNewWizardPage(@NonNull AbstractFileNewWizard wizard, @Nullable IResource initialSelection) {
        super(BaseUIMessages.NewWizardPage_pageName);
        this.wizard = wizard;
        this.initialSelection = initialSelection;
        this.setPageComplete(false);
        this.setTitle(wizard.getPageSummary());
        this.setDescription(wizard.getPageDescription());
    }

    public void createControl(Composite parent) {
        this.initDialog(this.initialSelection);
        Composite topLevel = this.dialog.createDialogArea(parent);
        this.validatePage();
        this.setControl((Control)topLevel);
    }

    public IFile createNewFile() {
        if (this.newFile != null) {
            return this.newFile;
        }
        this.newFile = this.dialog.getNewFile();
        final InputStream initialContents = this.getInitialContents();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFileOperation op = new CreateFileOperation(AbstractFileNewWizardPage.this.newFile, null, initialContents, AbstractFileNewWizardPage.this.wizard.getNewFileLabel());
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)AbstractFileNewWizardPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    AbstractFileNewWizardPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)AbstractFileNewWizardPage.this.getContainer().getShell(), (String)BaseUIMessages.NewWizardPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                Activator.log(this.getClass(), "createNewFile()", e.getCause());
                                MessageDialog.openError((Shell)AbstractFileNewWizardPage.this.getContainer().getShell(), (String)BaseUIMessages.NewWizardPage_internalErrorTitle, (String)NLS.bind((String)BaseUIMessages.NewWizardPage_internalErrorTitle, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Activator.log(((Object)((Object)this)).getClass(), "createNewFile()", e.getTargetException());
            MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)BaseUIMessages.NewWizardPage_internalErrorTitle, (String)NLS.bind((String)BaseUIMessages.NewWizardPage_internalErrorMessage, (Object)e.getTargetException().getMessage()), (int)0x10000000);
            return null;
        }
        return this.newFile;
    }

    public InputStream getInitialContents() {
        AbstractFileDialog dialog2 = this.dialog;
        IFile newFile2 = this.newFile;
        if (newFile2 != null && dialog2 != null && dialog2.isURIFieldValid()) {
            String initialContentsAsString = this.wizard.getInitialContentsAsString(newFile2, dialog2);
            return new ByteArrayInputStream(initialContentsAsString.getBytes());
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (this.dialog != null) {
            this.setPageComplete(this.validatePage());
        }
    }

    @NonNull
    public AbstractFileDialog initDialog(@Nullable IResource initialSelection) {
        AbstractFileDialog dialog2;
        this.dialog = dialog2 = this.wizard.createDialog(this, initialSelection);
        return dialog2;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.dialog.getGroup().setFocus();
        }
    }

    protected boolean validatePage() {
        this.setMessage(this.wizard.getPageDescription());
        this.setErrorMessage(null);
        return this.dialog.validateGroup();
    }
}

