/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.facet.core.internal.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetFactory;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;

public final class QueryToFacetSet {
    private static String nsUri = "http://www.eclipse.org/FacetSet/";
    private static String facetSetExtension = "facetSet";

    private QueryToFacetSet() {
    }

    public static void queryToFacetSet(Object source) throws IOException {
        String absolutePath = null;
        URI sourceURI = null;
        URI targetURI = null;
        if (source instanceof IFile) {
            absolutePath = ((IFile)source).getFullPath().toString();
            sourceURI = URI.createURI((String)absolutePath);
            String targetPath = (String)absolutePath.subSequence(0, absolutePath.lastIndexOf("."));
            targetURI = URI.createURI((String)targetPath);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resourceQuery = resourceSet.createResource(sourceURI);
        resourceQuery.load(Collections.EMPTY_MAP);
        ResourceSetImpl resourceSet2 = new ResourceSetImpl();
        Resource resourceFacet = resourceSet2.createResource(targetURI);
        FacetSet facetSet = FacetFactory.eINSTANCE.createFacetSet();
        resourceFacet.getContents().add((Object)facetSet);
        QueryToFacetSet.visitor(facetSet, resourceQuery);
        QueryToFacetSet.saveResourceAsXMI(targetURI, resourceFacet);
    }

    public static void visitor(FacetSet facetSet, Resource resourceQuery) {
        for (EObject object : resourceQuery.getContents()) {
            if (!(object instanceof ModelQuerySet)) continue;
            ModelQuerySet querySet = (ModelQuerySet)object;
            facetSet.setName(querySet.getName());
            facetSet.setExtendedPackage((EPackage)querySet.getAssociatedMetamodels().get(0));
            facetSet.setNsPrefix(querySet.getName());
            facetSet.setNsURI(String.valueOf(nsUri) + querySet.getName());
            for (ModelQuery query : querySet.getQueries()) {
                if (!query.getParameters().isEmpty() || !query.getReturnType().getName().equalsIgnoreCase("EBoolean")) continue;
                QueryToFacetSet.visitQuery(query, facetSet);
            }
        }
    }

    public static void visitQuery(ModelQuery query, FacetSet facetSet) {
        Facet facet = FacetFactory.eINSTANCE.createFacet();
        facet.setName(query.getName());
        facet.setConditionQuery(query);
        facet.setAbstract(true);
        facet.getESuperTypes().addAll((Collection)query.getScope());
        facetSet.getEClassifiers().add((Object)facet);
    }

    public static void saveResourceAsXMI(URI sourceURI, Resource resource) throws IOException {
        XMIResourceImpl xmiResource = new XMIResourceImpl();
        xmiResource.getContents().addAll((Collection)resource.getContents());
        xmiResource.setURI(sourceURI.appendFileExtension(facetSetExtension));
        xmiResource.save(null);
    }
}

