/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.team;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.emf.cdo.internal.team.bundle.OM;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;

public class RepositoryTeamProvider
extends RepositoryProvider {
    public static final String PROVIDER_ID = "org.eclipse.emf.cdo.team.TeamProvider";
    private static final QualifiedName SESSION_DESCRIPTION_KEY = new QualifiedName("org.eclipse.emf.cdo.team", "sessionDescription");
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, RepositoryTeamProvider.class);

    public String getID() {
        return PROVIDER_ID;
    }

    public void configureProject() throws CoreException {
        if (TRACER.isEnabled()) {
            TRACER.format("Configuring project {0}", new Object[]{this.getProject()});
        }
    }

    public void deconfigure() throws CoreException {
        if (TRACER.isEnabled()) {
            TRACER.format("Deconfiguring project {0}", new Object[]{this.getProject()});
        }
    }

    public static String getSessionDescription(IProject project) {
        try {
            return project.getPersistentProperty(SESSION_DESCRIPTION_KEY);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static void setSessionDescription(IProject project, String value) {
        try {
            project.setPersistentProperty(SESSION_DESCRIPTION_KEY, value);
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static boolean isMapped(IProject project) {
        return RepositoryProvider.getProvider((IProject)project, (String)PROVIDER_ID) != null;
    }

    public static void mapProject(IProject project, String sessionDescription) throws TeamException {
        RepositoryTeamProvider.map((IProject)project, (String)PROVIDER_ID);
        RepositoryTeamProvider.setSessionDescription(project, sessionDescription);
    }

    public static void unmapProject(IProject project) throws TeamException {
        RepositoryTeamProvider.unmap((IProject)project);
        RepositoryTeamProvider.setSessionDescription(project, null);
    }
}

