/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.theme;

import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.WorkspaceThemesHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.WorkspaceThemes;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.impl.ThemeImpl;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ThemeManager {
    public static String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.css.theme";
    public static ThemeManager instance = new ThemeManager();
    private Map<String, Theme> allThemes = null;
    private List<Theme> temporaryThemesList = new ArrayList<Theme>();
    private List<Theme> deletedThemesList = new ArrayList<Theme>();
    private WorkspaceThemesHelper workspaceThemesHelper = new WorkspaceThemesHelper();

    private ThemeManager() {
    }

    public List<Theme> getThemes() {
        LinkedList<Theme> sortedThemes = new LinkedList<Theme>(this.getAllThemes().values());
        Collections.sort(sortedThemes, ThemeComparator.instance);
        return sortedThemes;
    }

    public List<StyleSheet> getWorkspaceStyleSheets() {
        Theme current = this.findCurrentTheme();
        if (current == null) {
            return Collections.emptyList();
        }
        return current.getStylesheets();
    }

    public Theme getTheme(String themeId) {
        Theme registeredTheme = null;
        if (this.getAllThemes().containsKey(themeId)) {
            registeredTheme = this.getAllThemes().get(themeId);
        }
        if (registeredTheme == null) {
            registeredTheme = EmptyTheme.instance;
        }
        return registeredTheme;
    }

    public void reloadThemes() {
        this.allThemes = null;
    }

    public void refreshThemes() {
        String key;
        for (Theme addedTheme : this.temporaryThemesList) {
            key = addedTheme.getId();
            if (this.allThemes.containsKey(key)) continue;
            this.allThemes.put(key, addedTheme);
        }
        for (Theme deletedTheme : this.deletedThemesList) {
            key = deletedTheme.getId();
            if (!this.allThemes.containsKey(key)) continue;
            this.allThemes.remove(key);
        }
    }

    public void clearTemporaryThemes() {
        this.temporaryThemesList.clear();
    }

    public void clearDeletedThemes() {
        this.deletedThemesList.clear();
    }

    public void addTemporaryTheme(Theme temporaryTheme) {
        this.temporaryThemesList.add(temporaryTheme);
    }

    public void delete(Theme theme) {
        if (this.temporaryThemesList.contains(theme)) {
            this.temporaryThemesList.remove(theme);
        } else {
            this.deletedThemesList.add(theme);
        }
    }

    public Image getThemeIcon(Theme theme) {
        Path path;
        IConfigurationElement[] config;
        Image icon = null;
        String iconPath = theme.getIcon();
        if (iconPath != null && (icon = this.handleThemeDefinition(theme, config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID))) == null && (path = new Path(iconPath)).toFile().exists()) {
            icon = new Image((Device)PlatformUI.getWorkbench().getDisplay(), iconPath);
        }
        return icon;
    }

    public WorkspaceThemes getWorkspaceThemesPreferences() {
        WorkspaceThemes workspaceThemes = null;
        IPath path = this.workspaceThemesHelper.getThemeWorkspacePreferenceFilePath();
        if (path.toFile().exists()) {
            URI fileURI = CommonPlugin.resolve((URI)URI.createFileURI((String)path.toOSString()));
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(fileURI, true);
            workspaceThemes = (WorkspaceThemes)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)StylesheetsPackage.eINSTANCE.getWorkspaceThemes());
        }
        return workspaceThemes;
    }

    public boolean isEditable(String id) {
        boolean isEditable = this.temporaryThemesList.contains(this.allThemes.get(id));
        WorkspaceThemes workspacePreference = this.getWorkspaceThemesPreferences();
        if (workspacePreference != null && !isEditable) {
            Iterator themesIterator = workspacePreference.getThemes().iterator();
            while (themesIterator.hasNext() && !isEditable) {
                isEditable = id.equals(((Theme)themesIterator.next()).getId());
            }
        }
        return isEditable;
    }

    public void persist() {
        Theme[] editableThemes = this.getEditableThemes();
        this.workspaceThemesHelper.saveWorkspaceThemesPreferenceResource(editableThemes, this.deletedThemesList.toArray(new Theme[this.deletedThemesList.size()]));
        this.allThemes = null;
        this.deletedThemesList.clear();
        this.temporaryThemesList.clear();
    }

    private Theme[] getEditableThemes() {
        ArrayList<Theme> editableThemeList = new ArrayList<Theme>();
        for (Theme theme : this.allThemes.values()) {
            if (!this.isEditable(theme.getId())) continue;
            editableThemeList.add(theme);
        }
        return editableThemeList.toArray(new Theme[editableThemeList.size()]);
    }

    private Image handleThemeDefinition(Theme theme, IConfigurationElement[] config) {
        Image icon = null;
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement themeContribution = iConfigurationElementArray[n2];
            if (themeContribution.getName().equals("themeDefinition")) {
                String themeId = themeContribution.getAttribute("id");
                String themeLabel = themeContribution.getAttribute("label");
                if (themeId != null && themeId.equals(theme.getId()) && themeLabel != null && themeLabel.equals(theme.getLabel())) {
                    icon = org.eclipse.papyrus.infra.widgets.Activator.getDefault().getImage(themeContribution.getContributor().getName(), theme.getIcon());
                }
            }
            ++n2;
        }
        return icon;
    }

    private Map<String, Theme> getAllThemes() {
        if (this.allThemes == null) {
            this.allThemes = new LinkedHashMap<String, Theme>();
            this.allThemes.put(EmptyTheme.instance.getId(), EmptyTheme.instance);
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            this.loadThemeDefinitions(config);
            this.loadThemeContributions(config);
            this.loadThemePreferenceWorkspace();
            this.loadTemporaryThemes();
            for (Theme theme : this.deletedThemesList) {
                String themeId = theme.getId();
                if (!this.allThemes.containsKey(themeId)) continue;
                this.allThemes.remove(themeId);
            }
        }
        return this.allThemes;
    }

    private void loadThemeDefinitions(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement themeConfig = iConfigurationElementArray[n2];
            if (themeConfig.getName().equals("themeDefinition")) {
                String themeId = themeConfig.getAttribute("id");
                if (themeId == null) {
                    Activator.log.warn("Cannot define a CSS Theme with an empty id (Contributed by " + themeConfig.getContributor() + ")");
                } else {
                    Theme theme = StylesheetsFactory.eINSTANCE.createTheme();
                    theme.setId(themeId);
                    String themeLabel = themeConfig.getAttribute("label");
                    theme.setLabel(themeLabel);
                    String themeIcon = themeConfig.getAttribute("icon");
                    if (themeIcon != null) {
                        theme.setIcon(themeIcon);
                    }
                    this.allThemes.put(themeId, theme);
                }
            }
            ++n2;
        }
    }

    private void loadThemeContributions(IConfigurationElement[] config) {
        IConfigurationElement[] iConfigurationElementArray = config;
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement themeConfig = iConfigurationElementArray[n2];
            if (themeConfig.getName().equals("themeContribution")) {
                String themeId = themeConfig.getAttribute("id");
                if (themeId == null || !this.allThemes.containsKey(themeId)) {
                    Activator.log.warn("Cannot contribute to an undefined theme: " + themeId);
                } else {
                    IConfigurationElement[] stylesheets;
                    Theme theme = this.allThemes.get(themeId);
                    IConfigurationElement[] iConfigurationElementArray2 = stylesheets = themeConfig.getChildren("stylesheet");
                    int n3 = stylesheets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement stylesheetConfig = iConfigurationElementArray2[n4];
                        String path = stylesheetConfig.getAttribute("stylesheetPath");
                        try {
                            URL url = new URL("platform:/plugin/" + themeConfig.getContributor().getName() + "/" + path);
                            StyleSheetReference styleSheet = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
                            styleSheet.setPath(url.toString());
                            theme.getStylesheets().add((Object)styleSheet);
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void loadThemePreferenceWorkspace() {
        WorkspaceThemes workspaceThemes = this.getWorkspaceThemesPreferences();
        if (workspaceThemes != null) {
            for (Theme theme : workspaceThemes.getThemes()) {
                this.allThemes.put(theme.getId(), theme);
            }
        }
    }

    private void loadTemporaryThemes() {
        for (Theme theme : this.temporaryThemesList) {
            this.allThemes.put(theme.getId(), theme);
        }
    }

    private Theme findCurrentTheme() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.contains("currentTheme")) {
            String themeId = store.getString("currentTheme");
            return this.getTheme(themeId);
        }
        ArrayList<Theme> sortedThemes = new ArrayList<Theme>(this.getAllThemes().values());
        if (sortedThemes.size() < 2) {
            return EmptyTheme.instance;
        }
        Theme theme = (Theme)sortedThemes.get(1);
        store.setValue("currentTheme", theme.getId());
        try {
            ((IPersistentPreferenceStore)store).save();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        return theme;
    }

    public static class EmptyTheme
    extends ThemeImpl {
        public static Theme instance = new EmptyTheme();

        private EmptyTheme() {
            this.setId("none");
            this.setLabel("No theme");
            this.setIcon("icons/Delete_12x12.gif");
        }
    }

    private static class ThemeComparator
    implements Comparator<Theme> {
        public static Comparator<Theme> instance = new ThemeComparator();

        private ThemeComparator() {
        }

        @Override
        public int compare(Theme o1, Theme o2) {
            if (o1 == EmptyTheme.instance) {
                return -1;
            }
            if (o2 == EmptyTheme.instance) {
                return 1;
            }
            return Collator.getInstance().compare(o1.getLabel(), o2.getLabel());
        }
    }
}

