/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.notation;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.EObjectListValueStyle;
import org.eclipse.gmf.runtime.notation.NamedStyle;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.DiagramCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.resource.CSSNotationResource;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusDiagram;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class CSSDiagramImpl
extends DiagramImpl
implements CSSDiagram {
    protected ExtendedCSSEngine engine;
    private Adapter disposeListener;

    @Override
    public ExtendedCSSEngine getEngine() {
        if (this.engine == null) {
            this.engine = new DiagramCSSEngine(this.getModelEngine(), this);
            this.disposeListener = new DiagramDisposeListener();
            this.eResource().eAdapters().add((Object)this.disposeListener);
        }
        return this.engine;
    }

    private void disposeEngine(Object notifier) {
        if (this.engine != null) {
            this.engine.dispose();
            this.engine = null;
            ((Resource)notifier).eAdapters().remove((Object)this.disposeListener);
        }
    }

    protected ExtendedCSSEngine getModelEngine() {
        return CSSNotationResource.getEngine(this.eResource());
    }

    @Override
    public List<StyleSheet> getStyleSheets() {
        LinkedList<StyleSheet> result = new LinkedList<StyleSheet>();
        for (Object styleObject : this.getStyles()) {
            NamedStyle style;
            if (!(styleObject instanceof NamedStyle) || !"css_stylesheets".equals((style = (NamedStyle)styleObject).getName()) || !(style instanceof EObjectListValueStyle)) continue;
            EObjectListValueStyle stylesheetsStyle = (EObjectListValueStyle)style;
            for (Object eObjectValue : stylesheetsStyle.getEObjectListValue()) {
                if (!(eObjectValue instanceof StyleSheet)) continue;
                result.add((StyleSheet)eObjectValue);
            }
        }
        StyleSheet s = this.getViewpointDefinedStylesheet();
        if (s != null) {
            result.add(s);
        }
        return result;
    }

    private StyleSheet getViewpointDefinedStylesheet() {
        ViewPrototype proto = ViewPrototype.get((EObject)this);
        if (proto == null) {
            return null;
        }
        PapyrusView conf = proto.getConfiguration();
        if (conf == null || !(conf instanceof PapyrusDiagram)) {
            return null;
        }
        String path = ((PapyrusDiagram)conf).getCustomStyle();
        if (path == null || path.isEmpty()) {
            return null;
        }
        StyleSheetReference ref = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
        ref.setPath(path);
        return ref;
    }

    private class DiagramDisposeListener
    extends AdapterImpl {
        private DiagramDisposeListener() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 4: {
                    if (notification.getOldValue() != CSSDiagramImpl.this) break;
                    CSSDiagramImpl.this.disposeEngine(notification.getNotifier());
                    break;
                }
                case 6: {
                    for (Object object : (Collection)notification.getOldValue()) {
                        if (object != CSSDiagramImpl.this) continue;
                        CSSDiagramImpl.this.disposeEngine(notification.getNotifier());
                    }
                    break;
                }
            }
        }
    }
}

