/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.DiagramHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.WorkspaceCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheet;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.swt.widgets.Display;

public class ProjectCSSEngine
extends ExtendedCSSEngineImpl {
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (ProjectCSSEngine.this.project != null) {
                try {
                    if (event != null && event.getDelta() != null) {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta.getResource().equals((Object)(this).ProjectCSSEngine.this.stylesheetPreferences)) {
                                    ProjectCSSEngine.this.reset();
                                    DiagramHelper.setNeedsRefresh();
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            DiagramHelper.refreshDiagrams();
                                        }
                                    });
                                    return false;
                                }
                                return true;
                            }
                        });
                    }
                }
                catch (CoreException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
    };
    public static String PROJECT_STYLESHEETS = "stylesheets.xmi";
    protected IProject project;
    protected IFile stylesheetPreferences;

    @Deprecated
    public ProjectCSSEngine(Resource modelResource) {
        super(WorkspaceCSSEngine.instance);
        URI resourceURI = modelResource.getURI();
        if (resourceURI.isPlatformResource()) {
            String platformString = resourceURI.toPlatformString(true);
            try {
                Path workspacePath = new Path(platformString);
                this.project = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath).getProject();
                IPath preferencesAbsolutePath = new ProjectScope(this.project).getLocation().append(PROJECT_STYLESHEETS);
                IPath projectRelativePath = preferencesAbsolutePath.makeRelativeTo(this.project.getLocation());
                this.stylesheetPreferences = this.project.getFile(projectRelativePath);
                ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected ProjectCSSEngine(IProject project) {
        super(WorkspaceCSSEngine.instance);
        this.project = project;
        try {
            IPath preferencesAbsolutePath = new ProjectScope(project).getLocation().append(PROJECT_STYLESHEETS);
            IPath projectRelativePath = preferencesAbsolutePath.makeRelativeTo(project.getLocation());
            this.stylesheetPreferences = project.getFile(projectRelativePath);
            project.getWorkspace().addResourceChangeListener(this.resourceListener);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public static ProjectCSSEngine createEngine(Resource modelResource) {
        ProjectCSSEngine result = null;
        URI resourceURI = modelResource.getURI();
        if (resourceURI.isPlatformResource()) {
            String platformString = resourceURI.toPlatformString(true);
            try {
                Path workspacePath = new Path(platformString);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath).getProject();
                if (project.isAccessible()) {
                    result = new ProjectCSSEngine(project);
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        super.dispose();
    }

    @Override
    protected void reloadStyleSheets() {
        this.styleSheets.clear();
        if (this.project == null || !this.project.exists() || !this.project.isOpen()) {
            return;
        }
        if (this.stylesheetPreferences == null || !this.stylesheetPreferences.exists()) {
            return;
        }
        IPath workspacePath = this.stylesheetPreferences.getFullPath();
        URI workspaceURI = URI.createPlatformResourceURI((String)workspacePath.toString(), (boolean)true);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            Resource stylesheetsResource = resourceSet.getResource(workspaceURI, true);
            for (EObject rootElement : stylesheetsResource.getContents()) {
                if (!(rootElement instanceof StyleSheet)) continue;
                this.styleSheets.add((StyleSheet)rootElement);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    @Override
    protected void parseStyleSheet(StyleSheetReference styleSheet) throws IOException {
        IFile file;
        String path = styleSheet.getPath();
        if (path.startsWith("/")) {
            super.parseStyleSheet(styleSheet);
        } else if (this.project != null && this.project.exists() && this.project.isOpen() && (file = this.project.getFile(path)).exists()) {
            try {
                this.parseStyleSheet(file.getContents());
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }
}

