/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    public static final Comparator<String> STRING_ASCENDING_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1.length() == 0 || o2.length() == 0) {
                return o1.length() - o2.length();
            }
            LinkedList o1Parts = CommonUtils.splitIntoDigitAndNonDigitParts(o1);
            LinkedList o2Parts = CommonUtils.splitIntoDigitAndNonDigitParts(o2);
            Iterator o2PartsIterator = o2Parts.iterator();
            for (String o1Part : o1Parts) {
                int result;
                if (!o2PartsIterator.hasNext()) {
                    return 1;
                }
                String o2Part = (String)o2PartsIterator.next();
                if (Character.isDigit(o1Part.charAt(0)) && Character.isDigit(o2Part.charAt(0))) {
                    o1Part = CommonUtils.stripLeadingZeros(o1Part);
                    o2Part = CommonUtils.stripLeadingZeros(o2Part);
                    result = o1Part.length() - o2Part.length();
                    if (result == 0) {
                        result = o1Part.compareToIgnoreCase(o2Part);
                    }
                } else {
                    result = o1Part.compareToIgnoreCase(o2Part);
                }
                if (result == 0) continue;
                return result;
            }
            if (o2PartsIterator.hasNext()) {
                return -1;
            }
            return o1.compareTo(o2);
        }
    };
    public static final Comparator<Ref> REF_ASCENDING_COMPARATOR = new Comparator<Ref>(){

        @Override
        public int compare(Ref o1, Ref o2) {
            return STRING_ASCENDING_COMPARATOR.compare(o1.getName(), o2.getName());
        }
    };
    public static final Comparator<IResource> RESOURCE_NAME_COMPARATOR = new Comparator<IResource>(){

        @Override
        public int compare(IResource r1, IResource r2) {
            return Policy.getComparator().compare(r1.getName(), r2.getName());
        }
    };

    private CommonUtils() {
    }

    public static boolean runCommand(String commandId, IStructuredSelection selection) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command cmd = commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            return false;
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        EvaluationContext c = null;
        if (selection != null) {
            c = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection.toList());
            c.addVariable("selection", (Object)selection);
            c.removeVariable("activeMenuSelection");
        }
        try {
            if (c != null) {
                handlerService.executeCommandInContext(new ParameterizedCommand(cmd, null), null, (IEvaluationContext)c);
            } else {
                handlerService.executeCommand(commandId, null);
            }
            return true;
        }
        catch (CommandException commandException) {
            return false;
        }
    }

    private static LinkedList<String> splitIntoDigitAndNonDigitParts(String input) {
        LinkedList<String> parts = new LinkedList<String>();
        int partStart = 0;
        boolean previousWasDigit = Character.isDigit(input.charAt(0));
        int i = 1;
        while (i < input.length()) {
            boolean isDigit = Character.isDigit(input.charAt(i));
            if (isDigit != previousWasDigit) {
                parts.add(input.substring(partStart, i));
                partStart = i;
                previousWasDigit = isDigit;
            }
            ++i;
        }
        parts.add(input.substring(partStart));
        return parts;
    }

    private static String stripLeadingZeros(String input) {
        int i = 0;
        while (i < input.length()) {
            if (input.charAt(i) != '0') {
                return input.substring(i);
            }
            ++i;
        }
        return "";
    }
}

