/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.actions;

import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.modisco.jee.JEEActivator;
import org.eclipse.modisco.jee.actions.DeploymentDescriptorDiscoverer;
import org.eclipse.modisco.jee.actions.Messages;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class ProjectDeploymentDescriptorDiscoverer
implements Discoverer {
    public static final int FLUSH_LIMIT = 10000;
    private final ArrayList<Resource> listOfResource = new ArrayList();
    private static List<DiscoveryParameter> parametersKeys = null;
    private static final String XMI_EXTENSION = "xmi";

    public abstract DeploymentDescriptorDiscoverer getSingleFileDiscoverer();

    public abstract Resource.Factory getDiscovererFactory();

    public boolean isApplicableTo(Object source) {
        IProject project;
        if (source instanceof IFolder) {
            return true;
        }
        if (source instanceof IPackageFragment) {
            return true;
        }
        if (source instanceof IJavaProject) {
            return ((IJavaProject)source).getProject().isAccessible();
        }
        return source instanceof IProject && (project = (IProject)source).isAccessible();
    }

    public void listXmlFiles(String path, ArrayList<File> listPath) {
        File[] list;
        File projectFile = new File(path);
        File[] fileArray = list = projectFile.listFiles();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File element = fileArray[n2];
            if (element.isDirectory()) {
                this.listXmlFiles(element.getPath(), listPath);
            } else if (element.getName().contains(".") && element.getName().substring(element.getName().lastIndexOf(".")).equalsIgnoreCase(".xml")) {
                listPath.add(element);
            }
            ++n2;
        }
    }

    public static IProject getSourceProject(Object source) {
        IProject tempProject = null;
        if (source instanceof IProject) {
            tempProject = (IProject)source;
        } else if (source instanceof IJavaProject) {
            tempProject = ((IJavaProject)source).getProject();
        } else if (source instanceof IFolder) {
            tempProject = ((IFolder)source).getProject();
        } else if (source instanceof IPackageFragment) {
            tempProject = ((IPackageFragment)source).getResource().getProject();
        }
        return tempProject;
    }

    public static String getSourcePath(Object source) {
        String path = null;
        if (source instanceof IProject) {
            path = ((IProject)source).getLocation().toOSString();
        } else if (source instanceof IJavaProject) {
            path = ((IJavaProject)source).getPath().toOSString();
        } else if (source instanceof IFolder) {
            path = ((IFolder)source).getLocation().toOSString();
        } else if (source instanceof IPackageFragment) {
            path = ((IPackageFragment)source).getPath().toOSString();
        }
        return path;
    }

    public static Resource createResource(String resourceName) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)resourceName));
        return resource;
    }

    public void discoverElement(final Object source, final Map<DiscoveryParameter, Object> parameters) {
        boolean isSilent = false;
        parameters.put(DeploymentDescriptorDiscoverer.PARAMETER_SILENT_MODE, new Boolean(true));
        parameters.put(DeploymentDescriptorDiscoverer.PARAMETER_SERIALIZE_XMI, new Boolean(false));
        final IProject project = ProjectDeploymentDescriptorDiscoverer.getSourceProject(source);
        final IPath path = project.getProject().getLocation().addTrailingSeparator().append(project.getName()).addFileExtension(XMI_EXTENSION);
        Job job = new Job(Messages.ProjectDeploymentDescriptorDiscoverer_1){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = null;
                monitor.beginTask("", -1);
                try {
                    Resource resource = ProjectDeploymentDescriptorDiscoverer.createResource("platform:/resource/" + project.getProject().getName() + "/" + project.getProject().getName() + "." + ProjectDeploymentDescriptorDiscoverer.XMI_EXTENSION);
                    ArrayList<File> listFiles = new ArrayList<File>();
                    ProjectDeploymentDescriptorDiscoverer.this.listXmlFiles(ProjectDeploymentDescriptorDiscoverer.getSourcePath(source), listFiles);
                    ArrayList<Resource> resourceList = new ArrayList<Resource>();
                    for (File file : listFiles) {
                        ProjectDeploymentDescriptorDiscoverer.this.getSingleFileDiscoverer().discoverElement(file, parameters);
                        if (parameters.get(DeploymentDescriptorDiscoverer.PARAMETER_TARGET_RESOURCE) == null) continue;
                        resourceList.add((Resource)parameters.get(DeploymentDescriptorDiscoverer.PARAMETER_TARGET_RESOURCE));
                    }
                    for (Resource r : resourceList) {
                        resource.getContents().addAll((Collection)r.getContents());
                    }
                    ProjectDeploymentDescriptorDiscoverer.saveResource(resource, monitor);
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        result = Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((String)e.getMessage(), (Plugin)JEEActivator.getDefault());
                    }
                }
                finally {
                    monitor.done();
                    try {
                        IWorkspaceRoot root;
                        IFile ifile;
                        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        if (monitor.isCanceled() && (ifile = (root = ResourcesPlugin.getWorkspace().getRoot()).getFileForLocation(path)).exists()) {
                            ifile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Exception e1) {
                        MoDiscoLogger.logError((String)e1.getMessage(), (Plugin)JEEActivator.getDefault());
                    }
                }
                return result;
            }
        };
        if (!isSilent) {
            parameters.put(DeploymentDescriptorDiscoverer.PARAMETER_SILENT_MODE, new Boolean(false));
            ProjectDeploymentDescriptorDiscoverer.scheduleEditorOpening(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path), job, parameters);
        }
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            MoDiscoLogger.logError((String)e.getMessage(), (Plugin)JEEActivator.getDefault());
        }
    }

    public static void saveResource(Resource resource, IProgressMonitor monitor) throws IOException {
        HashMap<String, Constable> options = new HashMap<String, Constable>();
        options.put("FLUSH_THRESHOLD", Integer.valueOf(10000));
        options.put("USE_FILE_BUFFER", new Boolean(true));
        monitor.subTask(Messages.ProjectDeploymentDescriptorDiscoverer_2);
        resource.save(options);
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        if (parametersKeys == null) {
            parametersKeys = new ArrayList<DiscoveryParameter>();
            parametersKeys.add(DeploymentDescriptorDiscoverer.PARAMETER_SILENT_MODE);
            parametersKeys.add(DeploymentDescriptorDiscoverer.PARAMETER_TARGET_RESOURCE);
            parametersKeys.add(DeploymentDescriptorDiscoverer.PARAMETER_SERIALIZE_XMI);
        }
        return parametersKeys;
    }

    protected static final void openEditor(final IFile source) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IEditorDescriptor editDesc;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart existingEditorOnResource = page.findEditor((IEditorInput)new FileEditorInput(source));
                    if (existingEditorOnResource != null) {
                        page.closeEditor(existingEditorOnResource, true);
                    }
                    if ((editDesc = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.gmt.modisco.infra.browser.editorID")) != null) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source, (String)editDesc.getId());
                    } else {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)source);
                    }
                }
                catch (PartInitException e) {
                    MoDiscoLogger.logError((String)e.getMessage(), (Plugin)JEEActivator.getDefault());
                }
            }
        });
    }

    protected static void scheduleEditorOpening(final IFile source, Job job, Map<DiscoveryParameter, Object> parameters) {
        boolean isSilent = false;
        if (parameters != null) {
            isSilent = Boolean.TRUE.equals(parameters.get(DeploymentDescriptorDiscoverer.PARAMETER_SILENT_MODE));
        }
        if (!isSilent) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getJob().getResult().isOK()) {
                        ProjectDeploymentDescriptorDiscoverer.openEditor(source);
                    }
                }
            });
        }
    }

    public Resource discoverElement(Object source, URI target) {
        HashMap<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
        parameters.put(DeploymentDescriptorDiscoverer.PARAMETER_SILENT_MODE, new Boolean(true));
        parameters.put(DeploymentDescriptorDiscoverer.PARAMETER_SERIALIZE_XMI, new Boolean(false));
        this.discoverElement(source, parameters);
        return (Resource)parameters.get(DeploymentDescriptorDiscoverer.PARAMETER_TARGET_RESOURCE);
    }

    protected ArrayList<Resource> getListOfResource() {
        return this.listOfResource;
    }
}

