/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.views.permissions;

import java.util.ArrayList;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.core.internal.views.permissions.EntryId;
import org.polarsys.chess.core.internal.views.permissions.PermissionEntry;
import org.polarsys.chess.core.util.CHESSProjectSupport;

public class PermissionList
extends ArrayList<PermissionEntry> {
    private static final long serialVersionUID = 6775060867788553534L;

    public PermissionList getEntry(Element el, Stereotype str, Feature feature) {
        EntryId id = EntryId.generateEntryId(el, str, feature);
        return this.getEntry(id);
    }

    public PermissionList getEntry(EntryId id) {
        PermissionList l = new PermissionList();
        for (PermissionEntry pe : this) {
            if (pe.match(id) == null) continue;
            l.add(pe);
        }
        return l;
    }

    public boolean checkPermission(EntryId id, byte permission) {
        PermissionList l = this.getEntry(id);
        if ((l = this.merge(l)).isEmpty()) {
            return false;
        }
        for (PermissionEntry pe : l) {
            if (pe.checkPermission(permission)) continue;
            CHESSProjectSupport.printlnToCHESSConsole(id + " " + PermissionEntry.getPermissionType(permission) + " <=> " + pe.getId());
            return false;
        }
        return true;
    }

    private PermissionList merge(PermissionList list) {
        if (list.size() == 1) {
            return list;
        }
        int i = 0;
        while (i < list.size()) {
            PermissionEntry pei = (PermissionEntry)list.get(i);
            int j = i + 1;
            while (j < list.size()) {
                PermissionEntry pej = (PermissionEntry)list.get(j);
                if (pei.getId().equals(pej.getId()) && pei.getDomain().equals((Object)pej.getDomain())) {
                    PermissionEntry pe;
                    CHESSProjectSupport.printlnToCHESSConsole(pei.getId() + "||" + pej.getId());
                    list.remove(j--);
                    pei = pe = new PermissionEntry(pei.getId(), pei.isOwner() || pej.isOwner(), pei.isWriteable() || pej.isWriteable(), pei.isVisible() || pej.isVisible(), pei.getDomain());
                    list.set(i, pe);
                }
                ++j;
            }
            ++i;
        }
        return list;
    }
}

