/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.AbstractRepresentationDialectServices;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterRegistry;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.TreeFactory;
import org.eclipse.sirius.tree.business.api.interaction.DTreeUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.dialect.description.TreeInterpretedExpressionQuery;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.tools.internal.command.TreeCommandFactory;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class TreeDialectServices
extends AbstractRepresentationDialectServices {
    protected boolean isSupported(RepresentationDescription description) {
        return description instanceof TreeDescription;
    }

    protected boolean isSupported(DRepresentation representation) {
        return representation instanceof DTree;
    }

    public DRepresentation createRepresentation(String name, EObject semantic, RepresentationDescription description, IProgressMonitor monitor) {
        DTree tree = null;
        try {
            monitor.beginTask("Create tree : " + name, 11);
            monitor.subTask("Create tree : " + name);
            Session session = SessionManager.INSTANCE.getSession(semantic);
            TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
            Resource descriptionRes = description.eResource();
            if (!domain.getResourceSet().getResources().contains((Object)descriptionRes)) {
                domain.getResourceSet().getResources().add((Object)descriptionRes);
            }
            tree = TreeFactory.eINSTANCE.createDTree();
            tree.setName(name);
            tree.setDescription((TreeDescription)description);
            tree.setTarget(semantic);
            monitor.worked(1);
            this.refresh(tree, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        finally {
            monitor.done();
        }
        return tree;
    }

    public void initRepresentations(Viewpoint vp, EObject semantic) {
        super.initRepresentations(semantic, vp, TreeDescription.class);
    }

    public void initRepresentations(Viewpoint vp, EObject semantic, IProgressMonitor monitor) {
        super.initRepresentations(semantic, vp, TreeDescription.class, monitor);
    }

    protected <T extends RepresentationDescription> void initRepresentationForElement(T representationDescription, EObject semanticElement, IProgressMonitor monitor) {
        TreeDescription treeDescription;
        if (representationDescription instanceof TreeDescription && this.shouldInitializeRepresentation(semanticElement, treeDescription = (TreeDescription)representationDescription, treeDescription.getDomainClass())) {
            ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semanticElement);
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)semanticElement);
            if (modelAccessor.eInstanceOf(semanticElement, treeDescription.getDomainClass())) {
                boolean canCreate = true;
                if (treeDescription.getPreconditionExpression() != null && !StringUtil.isEmpty((String)treeDescription.getPreconditionExpression())) {
                    try {
                        canCreate = InterpreterUtil.getInterpreter((EObject)semanticElement).evaluateBoolean(semanticElement, treeDescription.getPreconditionExpression());
                    }
                    catch (EvaluationException evaluationException) {
                        canCreate = false;
                    }
                }
                if (canCreate) {
                    try {
                        monitor.beginTask("Initialize tree of type " + new IdentifiedElementQuery(representationDescription).getLabel(), 1);
                        TreeCommandFactory treeCommandFactory = new TreeCommandFactory(domain);
                        treeCommandFactory.setModelAccessor(modelAccessor);
                        DCommand command = treeCommandFactory.buildCreateTreeFromDescription(treeDescription, semanticElement, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        domain.getCommandStack().execute((Command)command);
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    public DRepresentation copyRepresentation(DRepresentation representation, String name, Session session, IProgressMonitor monitor) {
        DRepresentation newRepresentation = super.copyRepresentation(representation, name, session, monitor);
        session.getServices().putCustomData("DREPRESENTATION", ((DSemanticDecorator)representation).getTarget(), (EObject)newRepresentation);
        return newRepresentation;
    }

    protected void initRepresentation(RepresentationDescription description, EObject target) {
    }

    public void refresh(DRepresentation representation, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Tree refresh", 1);
            if (this.canRefresh(representation)) {
                this.refreshTree((DTree)representation, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    public RepresentationDescription getDescription(DRepresentation representation) {
        if (this.isSupported(representation)) {
            return ((DTree)representation).getDescription();
        }
        return null;
    }

    private void refreshTree(DTree tree, IProgressMonitor monitor) {
        Session session = SessionManager.INSTANCE.getSession(tree.getTarget());
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(tree.getTarget());
        InterpreterRegistry.prepareImportsFromSession((IInterpreter)interpreter, (Session)session);
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(tree.getTarget());
        DTreeUserInteraction interaction = new DTreeUserInteraction(tree, new GlobalContext(accessor, session));
        interaction.refreshContent((IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    public boolean canCreate(EObject semantic, RepresentationDescription desc) {
        boolean result = false;
        if (semantic != null && this.isSupported(desc)) {
            TreeDescription treeDesc = (TreeDescription)desc;
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(semantic);
            if (accessor != null) {
                result = this.checkDomainClass(accessor, semantic, treeDesc.getDomainClass());
            }
            result = result && this.checkPrecondition(semantic, treeDesc.getPreconditionExpression());
        }
        return result;
    }

    public IInterpretedExpressionQuery createInterpretedExpressionQuery(EObject target, EStructuralFeature feature) {
        return new TreeInterpretedExpressionQuery(target, feature);
    }

    public boolean handles(RepresentationDescription representationDescription) {
        return representationDescription instanceof TreeDescription;
    }

    public boolean handles(RepresentationExtensionDescription representationExtensionDescription) {
        return false;
    }
}

