/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.EmfResourceChangeUtil;

public class EmfResourceRenameStrategy
extends AbstractRenameStrategy {
    @Inject
    private EmfResourceChangeUtil changeUtil;

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        Resource targetResource = resourceSet.getResource(this.getTargetElementOriginalURI().trimFragment(), false);
        EcoreUtil.resolveAll((Resource)targetResource);
        this.applyDeclarationChange(newName, resourceSet);
        try {
            try {
                this.changeUtil.addSaveAsUpdate(targetResource, updateAcceptor);
            }
            catch (IOException exc) {
                updateAcceptor.getRefactoringStatus().add(3, exc.getMessage(), new Object[0]);
                this.revertDeclarationChange(resourceSet);
            }
        }
        finally {
            this.revertDeclarationChange(resourceSet);
        }
    }

    protected EAttribute getNameAttribute(EObject targetElement) {
        if (targetElement instanceof ENamedElement) {
            return EcorePackage.Literals.ENAMED_ELEMENT__NAME;
        }
        return null;
    }
}

