/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.common.base.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.UndoEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.ui.util.DisplayRunnableWithResult;

public class EditorDocumentUndoChange
extends Change {
    private static final Logger LOG = Logger.getLogger(EditorDocumentUndoChange.class);
    private String name;
    private UndoEdit undoEdit;
    private String editorID;
    private IEditorInput editorInput;
    private IWorkbenchPage page;
    private boolean doSave;

    public EditorDocumentUndoChange(String name, ITextEditor editor, UndoEdit undoEdit, boolean doSave) {
        this.name = name;
        IWorkbenchPartSite site = editor.getSite();
        this.page = site.getPage();
        this.editorID = site.getId();
        this.editorInput = editor.getEditorInput();
        this.undoEdit = undoEdit;
        this.doSave = doSave;
    }

    public String getName() {
        return this.name;
    }

    protected ITextEditor getEditor() {
        try {
            IEditorPart editor = this.page.findEditor(this.editorInput);
            if (editor != null && Objects.equal((Object)editor.getSite().getId(), (Object)this.editorID)) {
                return (ITextEditor)editor;
            }
            return (ITextEditor)this.page.openEditor(this.editorInput, this.editorID);
        }
        catch (Exception exc) {
            LOG.error((Object)"Error restoring editor", (Throwable)exc);
            return null;
        }
    }

    public Object getModifiedElement() {
        return null;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public Change perform(final IProgressMonitor pm) throws CoreException {
        return (Change)new DisplayRunnableWithResult<Change>(){

            @Override
            protected Change run() throws Exception {
                IDocument document = null;
                try {
                    document = EditorDocumentUndoChange.this.acquireDocument(pm);
                    UndoEdit undo = EditorDocumentUndoChange.this.performEdits(document);
                    EditorDocumentUndoChange.this.commit(document, pm);
                    Change change = EditorDocumentUndoChange.this.createUndoChange(undo);
                    return change;
                }
                catch (BadLocationException e) {
                    throw Changes.asCoreException((BadLocationException)e);
                }
                catch (MalformedTreeException e) {
                    throw Changes.asCoreException((MalformedTreeException)e);
                }
                finally {
                    EditorDocumentUndoChange.this.releaseDocument(document, pm);
                }
            }
        }.syncExec();
    }

    protected UndoEdit performEdits(IDocument document) throws BadLocationException, MalformedTreeException {
        DocumentRewriteSession session = null;
        try {
            if (document instanceof IDocumentExtension4) {
                session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
            }
            UndoEdit undoEdit = this.undoEdit.apply(document);
            return undoEdit;
        }
        finally {
            if (session != null) {
                ((IDocumentExtension4)document).stopRewriteSession(session);
            }
        }
    }

    protected IDocument acquireDocument(IProgressMonitor pm) {
        return (IDocument)new DisplayRunnableWithResult<IDocument>(){

            @Override
            protected IDocument run() throws Exception {
                ITextEditor editor = EditorDocumentUndoChange.this.getEditor();
                return editor != null ? editor.getDocumentProvider().getDocument((Object)EditorDocumentUndoChange.this.editorInput) : null;
            }
        }.syncExec();
    }

    protected void commit(IDocument document, IProgressMonitor pm) throws CoreException {
        if (this.doSave) {
            this.getEditor().doSave(pm);
        }
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
    }

    protected Change createUndoChange(UndoEdit edit) {
        return new EditorDocumentUndoChange(this.getName(), this.getEditor(), edit, this.doSave);
    }
}

