/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.ui.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelDecorator;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.custom.core.internal.exported.CustomizationUtils;
import org.eclipse.papyrus.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.ImageManager;
import org.eclipse.papyrus.emf.facet.custom.ui.internal.PropertiesHandler;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.papyrus.emf.facet.util.jface.ui.imageprovider.IImageProvider;
import org.eclipse.papyrus.emf.facet.util.jface.ui.imageprovider.IImageProviderFactory;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedLabelDecorator
extends LabelDecorator {
    private final ICustomizationManager customizationMgr;
    private final PropertiesHandler propertiesHandler;
    private final ImageManager imageManager;

    public CustomizedLabelDecorator(ICustomizationManager customizationMgr) {
        this.customizationMgr = customizationMgr;
        this.propertiesHandler = new PropertiesHandler(customizationMgr);
        this.imageManager = new ImageManager();
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element, IDecorationContext context) {
        Image result = null;
        if (image != null && element instanceof EObject) {
            IImage bLeftIImage = this.getPropertyValue(element, this.propertiesHandler.getBottomLeftOverlayProperty(), null, IImage.class);
            ImageDescriptor bottomLeftImDesc = this.imageManager.getImageDescriptor(bLeftIImage);
            IImage tLeftIImage = this.getPropertyValue(element, this.propertiesHandler.getTopLeftOverlayProperty(), null, IImage.class);
            ImageDescriptor topLeftImDesc = this.imageManager.getImageDescriptor(tLeftIImage);
            IImage bRightIImage = this.getPropertyValue(element, this.propertiesHandler.getBottomRightOverlayProperty(), null, IImage.class);
            ImageDescriptor bottomRightImDesc = this.imageManager.getImageDescriptor(bRightIImage);
            IImage tRightIImage = this.getPropertyValue(element, this.propertiesHandler.getTopRightOverlayProperty(), null, IImage.class);
            ImageDescriptor topRightImDesc = this.imageManager.getImageDescriptor(tRightIImage);
            ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
            imageDescriptorArray[0] = topLeftImDesc;
            imageDescriptorArray[1] = topRightImDesc;
            imageDescriptorArray[2] = bottomLeftImDesc;
            imageDescriptorArray[3] = bottomRightImDesc;
            ImageDescriptor[] overlaysArray = imageDescriptorArray;
            DecorationOverlayIcon overlayIcon = new DecorationOverlayIcon(image, overlaysArray);
            IImageProvider imageProvider = IImageProviderFactory.DEFAULT.createIImageProvider((Plugin)Activator.getDefault());
            result = imageProvider.getImage(overlayIcon);
        }
        return result;
    }

    public String decorateText(String text, Object element, IDecorationContext context) {
        return null;
    }

    public boolean prepareDecoration(Object element, String originalText, IDecorationContext context) {
        return false;
    }

    private <T> T getPropertyValue(Object element, FacetOperation property, ETypedElement eTypedElement, Class<T> classs) {
        return (T)CustomizationUtils.getPropertyValue((ICustomizationManager)this.customizationMgr, (Object)element, (FacetOperation)property, (ETypedElement)eTypedElement, classs);
    }
}

