/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xpand2.pr.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSIO {
    private static final char[] FILE_DELIMITER = new char[]{'\\', '/'};
    private static final int bufferSize = 65535;

    private static void getAllFilesInternal(File aPath, FilenameFilter aFilter, List<File> aList) {
        File[] allFiles = aPath.listFiles(aFilter);
        int i = 0;
        while (i < allFiles.length) {
            if (allFiles[i].isDirectory()) {
                FSIO.getAllFilesInternal(allFiles[i], aFilter, aList);
            } else {
                aList.add(allFiles[i]);
            }
            ++i;
        }
    }

    public static String readSingleFile(String aFilePath) throws IOException {
        if (aFilePath == null) {
            throw new IllegalArgumentException("Fileparameter should not be null!");
        }
        return FSIO.readSingleFile(new File(aFilePath), null);
    }

    public static String readSingleFile(File aFile, String fileEncoding) throws IOException {
        int len;
        if (aFile == null) {
            throw new IllegalArgumentException("Fileparameter should not be null!");
        }
        if (!aFile.isFile()) {
            throw new IOException(String.valueOf(aFile.getPath()) + " is not a file!");
        }
        if (!aFile.canRead()) {
            throw new IOException(String.valueOf(aFile.getPath()) + " is not a readable!");
        }
        StringBuffer aString = new StringBuffer();
        InputStreamReader aFileReader = null;
        aFileReader = fileEncoding == null ? new FileReader(aFile) : new InputStreamReader((InputStream)new FileInputStream(aFile), fileEncoding);
        char[] chars = new char[65535];
        while ((len = aFileReader.read(chars)) != -1) {
            aString.append(chars, 0, len);
        }
        ((Reader)aFileReader).close();
        return aString.toString();
    }

    public static String readSingleFile(Reader aReader) throws IOException {
        int len;
        if (aReader == null) {
            throw new IllegalArgumentException("Reader must not be null!");
        }
        StringBuffer aString = new StringBuffer();
        char[] chars = new char[65535];
        while ((len = aReader.read(chars)) != -1) {
            aString.append(chars, 0, len);
        }
        aReader.close();
        return aString.toString();
    }

    public static void writeSingleFile(Writer aWriter, CharSequence text) throws IOException {
        if (aWriter == null) {
            throw new IllegalArgumentException("Reader must not be null!");
        }
        StringReader reader = new StringReader(text.toString());
        FSIO.writeSingleFile(aWriter, reader);
    }

    public static void writeSingleFile(Writer aWriter, Reader aReader) throws IOException {
        int len;
        if (aWriter == null) {
            throw new IllegalArgumentException("Reader must not be null!");
        }
        char[] chars = new char[4096];
        while ((len = aReader.read(chars)) != -1) {
            aWriter.write(chars, 0, len);
        }
        aReader.close();
        aWriter.close();
    }

    public static File[] getAllFiles(File aPath, FilenameFilter aFilter) throws IOException {
        if (!aPath.isDirectory()) {
            throw new IOException(String.valueOf(aPath.getPath()) + " is not a directory!");
        }
        ArrayList<File> returnList = new ArrayList<File>();
        FSIO.getAllFilesInternal(aPath, aFilter, returnList);
        return returnList.toArray(new File[returnList.size()]);
    }

    public static File[] getAllFiles(String aBasePath, FilenameFilter aFilter) throws IOException {
        return FSIO.getAllFiles(new File(aBasePath), aFilter);
    }

    public static String normalizePath(String aFileName) {
        int i = 0;
        while (i < FILE_DELIMITER.length) {
            aFileName = aFileName.replace(FILE_DELIMITER[i], File.separatorChar);
            ++i;
        }
        return aFileName;
    }
}

