/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateSignatureUtil {
    public static Set<Type> getAccessibleTypes(TemplateSignature signature) {
        HashSet<Type> list = new HashSet<Type>();
        for (TemplateParameter current : signature.getParameters()) {
            ParameterableElement exposedElement = current.getOwnedParameteredElement();
            if (!(exposedElement instanceof Type)) continue;
            list.add((Type)exposedElement);
        }
        return list;
    }

    public static Type findTypeByName(TemplateSignature signature, String name) {
        Type type = null;
        boolean isFound = false;
        if ("".equals(name)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.uml.tools.utils", "Name parameter should not be an empty string."));
        } else {
            Iterator<Type> it = TemplateSignatureUtil.getAccessibleTypes(signature).iterator();
            while (!isFound && it.hasNext()) {
                Type t = it.next();
                if (!t.getName().equals(name)) continue;
                isFound = true;
                type = t;
            }
        }
        return type;
    }
}

