/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.papyrus.infra.tools.util.StringHelper;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.ParameterUtil;
import org.eclipse.papyrus.uml.tools.utils.TypedElementUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.TypedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationUtil {
    public static String getCustomLabel(Operation operation, Collection<String> maskValues) {
        String modifiers;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (maskValues.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)operation));
        }
        if (maskValues.contains("name")) {
            buffer.append(" ");
            buffer.append(operation.getName());
        }
        buffer.append("(");
        buffer.append(OperationUtil.getParametersAsString(operation, maskValues));
        buffer.append(")");
        if (maskValues.contains("returnType") || maskValues.contains("type")) {
            buffer.append(OperationUtil.getReturnTypeAsString(operation, maskValues));
        }
        if (maskValues.contains("modifiers") && !(modifiers = OperationUtil.getModifiersAsString(operation)).equals("")) {
            buffer.append("{");
            buffer.append(modifiers);
            buffer.append("}");
        }
        return buffer.toString();
    }

    private static String getReturnTypeAsString(Operation operation, Collection<String> maskValues) {
        boolean displayType = maskValues.contains("returnType") || maskValues.contains("type");
        boolean displayMultiplicity = maskValues.contains("returnMultiplicity") || maskValues.contains("multiplicity");
        StringBuffer label = new StringBuffer("");
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null && (displayType || displayMultiplicity)) {
            label.append(": ");
            if (displayType) {
                label.append(TypedElementUtil.getTypeAsString((TypedElement)returnParameter));
            }
            if (displayMultiplicity) {
                label.append(MultiplicityElementUtil.getMultiplicityAsString((MultiplicityElement)returnParameter));
            }
        }
        return label.toString();
    }

    private static String getParametersAsString(Operation operation, Collection<String> maskValues) {
        StringBuffer paramString = new StringBuffer();
        Iterator paramIterator = operation.getOwnedParameters().iterator();
        boolean firstParameter = true;
        while (paramIterator.hasNext()) {
            String parameterString;
            Parameter parameter = (Parameter)paramIterator.next();
            if (parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL) || (parameterString = ParameterUtil.getCustomLabel(parameter, OperationUtil.extractParameterMaskValues(maskValues))).trim().equals("")) continue;
            if (!firstParameter) {
                paramString.append(", ");
            }
            paramString.append(parameterString);
            firstParameter = false;
        }
        return paramString.toString();
    }

    private static Collection<String> extractParameterMaskValues(Collection<String> operationMaskValues) {
        HashSet<String> result = new HashSet<String>();
        for (String maskValue : operationMaskValues) {
            if (!maskValue.startsWith("parameters")) continue;
            String newValue = StringHelper.firstToLower((String)maskValue.replace("parameters", ""));
            result.add(newValue);
        }
        return result;
    }

    private static String getModifiersAsString(Operation operation) {
        StringBuffer buffer = new StringBuffer();
        boolean needsComma = false;
        Parameter returnParameter = OperationUtil.getReturnParameter(operation);
        if (returnParameter != null) {
            if (!returnParameter.isUnique()) {
                buffer.append("nonunique");
                needsComma = true;
            }
            if (returnParameter.isOrdered()) {
                if (needsComma) {
                    buffer.append(", ");
                }
                buffer.append("ordered");
                needsComma = true;
            }
        }
        if (operation.isQuery()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("query");
            needsComma = true;
        }
        for (Operation currentOperation : operation.getRedefinedOperations()) {
            if (needsComma) {
                buffer.append(", ");
            }
            buffer.append("redefines ");
            buffer.append(currentOperation.getName());
            needsComma = true;
        }
        for (Constraint constraint : operation.getOwnedRules()) {
            if (needsComma) {
                buffer.append(", ");
            }
            if (constraint.getSpecification() != null) {
                buffer.append(constraint.getSpecification().stringValue());
            }
            needsComma = true;
        }
        return buffer.toString();
    }

    private static Parameter getReturnParameter(Operation operation) {
        Parameter returnParameter = null;
        Iterator it = operation.getOwnedParameters().iterator();
        while (returnParameter == null && it.hasNext()) {
            Parameter parameter = (Parameter)it.next();
            if (!parameter.getDirection().equals((Object)ParameterDirectionKind.RETURN_LITERAL)) continue;
            returnParameter = parameter;
        }
        return returnParameter;
    }
}

