/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.tools.utils.Activator;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationUtil {
    private EnumerationUtil() {
    }

    public static final EnumerationLiteral findEnumerationLiteral(Enumeration enumeration, Enumerator enumerator) {
        EnumerationLiteral lit = enumeration.getOwnedLiteral(enumerator.getLiteral());
        if (lit != null) {
            return lit;
        }
        Activator.log.error(NLS.bind((String)"The EnumerationLiteral for {0} has not been found", (Object)enumerator), (Throwable)new NullPointerException());
        return null;
    }

    public static final List<EnumerationLiteral> adaptToEnumerationLiteralList(Enumeration enumeration, Collection<?> toAdapt) {
        ArrayList<EnumerationLiteral> returnedValue = new ArrayList<EnumerationLiteral>();
        for (Object object : toAdapt) {
            if (object instanceof EnumerationLiteral) {
                returnedValue.add((EnumerationLiteral)object);
                continue;
            }
            if (!(object instanceof Enumerator)) continue;
            returnedValue.add(EnumerationUtil.findEnumerationLiteral(enumeration, (Enumerator)object));
        }
        assert (returnedValue.size() == toAdapt.size());
        return returnedValue;
    }

    public static final List<Enumerator> adaptToEnumeratorList(EEnum eenum, Collection<?> toConvert) {
        ArrayList<Enumerator> convertedvalues = new ArrayList<Enumerator>();
        for (Object object : toConvert) {
            EEnumLiteral literal;
            if (!(object instanceof EnumerationLiteral) || (literal = eenum.getEEnumLiteral(((EnumerationLiteral)object).getName())) == null) continue;
            convertedvalues.add(literal.getInstance());
        }
        return convertedvalues;
    }

    public static final Enumerator adaptToEnumerator(EEnum eenum, EnumerationLiteral umlLiteral) {
        EEnumLiteral literal = eenum.getEEnumLiteral(umlLiteral.getName());
        if (literal != null) {
            return literal.getInstance();
        }
        return null;
    }
}

