/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;

public class ConnectorHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand gmfCommand = super.getBeforeMoveCommand(request);
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof ConnectorEnd)) continue;
            gmfCommand = UnexecutableCommand.INSTANCE;
            break;
        }
        return gmfCommand;
    }

    protected ICommand getBeforeReorientRelationshipCommand(ReorientRelationshipRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Destroy Connector View Command");
        EObject relationShip = request.getRelationship();
        Edge reorientedEdge = RequestParameterUtils.getReconnectedEdge((IEditCommandRequest)request);
        if (relationShip instanceof Connector) {
            EObject newEnd = request.getNewRelationshipEnd();
            EObject oldEnd = request.getOldRelationshipEnd();
            if (oldEnd != newEnd) {
                Set<View> viewsToDestroy = new ConnectorUtils().getViewsRepresentingConnector((Connector)relationShip);
                for (View current : viewsToDestroy) {
                    if (current == reorientedEdge) continue;
                    DestroyElementRequest destroyRequest = new DestroyElementRequest(request.getEditingDomain(), (EObject)current, false);
                    IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)current);
                    compositeCommand.add((IUndoableOperation)commandProvider.getEditCommand((IEditCommandRequest)destroyRequest));
                }
            }
        }
        if (!compositeCommand.isEmpty()) {
            return compositeCommand;
        }
        return null;
    }
}

