/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ObjectFlowReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.papyrus.uml.tools.utils.ObjectFlowUtil;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ObjectFlow;

public class ObjectFlowEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ObjectFlowReorientCommand(req);
    }

    protected boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        return this.canCreate(source, target);
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target, RequestParameterUtils.getSourceView((IEditCommandRequest)req), RequestParameterUtils.getTargetView((IEditCommandRequest)req))) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            if (source != null && !(source instanceof ActivityNode)) {
                return UnexecutableCommand.INSTANCE;
            }
            return IdentityCommand.INSTANCE;
        }
        Activity proposedContainer = this.deduceContainer(req);
        if (proposedContainer == null) {
            return UnexecutableCommand.INSTANCE;
        }
        req.setContainer((EObject)proposedContainer);
        return new CreateRelationshipCommand(req);
    }

    protected Activity deduceContainer(CreateRelationshipRequest request) {
        return this.deduceContainer(request.getSource(), request.getTarget());
    }

    protected Activity deduceContainer(EObject source, EObject target) {
        EObject element = source;
        while (element != null) {
            if (element instanceof Activity) {
                return (Activity)element;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected ICommand getConfigureCommand(final ConfigureRequest req) {
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                ObjectFlow element = (ObjectFlow)req.getElementToConfigure();
                ActivityNode source = ObjectFlowEditHelper.this.getSourceObject(req);
                ActivityNode target = ObjectFlowEditHelper.this.getTargetObject(req);
                if (source != null) {
                    element.setSource(ObjectFlowEditHelper.this.getSourceObject(req));
                }
                if (target != null) {
                    element.setTarget(target);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    protected ActivityNode getSourceObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.source");
        return result instanceof ActivityNode ? (ActivityNode)result : null;
    }

    protected ActivityNode getTargetObject(ConfigureRequest req) {
        Object result = req.getParameter("CreateRelationshipRequest.target");
        return result instanceof ActivityNode ? (ActivityNode)result : null;
    }

    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof ActivityNode)) {
            return false;
        }
        if (target != null && !(target instanceof ActivityNode)) {
            return false;
        }
        Activity container = this.deduceContainer(source, target);
        if (container == null) {
            return false;
        }
        return ObjectFlowUtil.canExistObjectFlow((Activity)container, null, (ActivityNode)((ActivityNode)source), (ActivityNode)((ActivityNode)target));
    }
}

