/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.tool.BehaviorTool;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ActivateBehaviorToolsCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.DeactivateBehaviorToolsCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.FiltersPropertySection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BehaviorsPropertySection
extends FiltersPropertySection {
    @Override
    protected Collection<?> getAppliedElements() {
        HashSet result = new HashSet();
        if (this.getDiagram() != null) {
            result.addAll(this.getDiagram().getActivateBehaviors());
        }
        return result;
    }

    @Override
    protected Collection<?> getAvailableElements() {
        HashSet<BehaviorTool> result = new HashSet<BehaviorTool>();
        DDiagram diagram = this.getDiagram();
        if (diagram != null && diagram.getDescription() != null) {
            Session session = null;
            if (diagram instanceof DSemanticDiagram) {
                session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram).getTarget());
            }
            for (Object currentTool : new DiagramComponentizationManager().getAllTools(session.getSelectedViewpoints(false), diagram.getDescription())) {
                if (!(currentTool instanceof BehaviorTool)) continue;
                result.add((BehaviorTool)currentTool);
            }
        }
        result.removeAll(this.getAppliedElements());
        return result;
    }

    @Override
    protected Composite createFeatureComposite(Composite composite) {
        Composite featureComposite = this.getWidgetFactory().createComposite(composite, 0);
        featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        featureComposite.setLayout((Layout)new GridLayout());
        Label featureLabel = this.getWidgetFactory().createLabel(featureComposite, "Activated Behaviors", 0);
        featureLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        return featureComposite;
    }

    @Override
    protected Composite createChoiceComposite(Composite composite) {
        Composite choiceComposite = this.getWidgetFactory().createComposite(composite, 0);
        choiceComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        choiceComposite.setLayout((Layout)new GridLayout());
        Label choiceLabel = this.getWidgetFactory().createLabel(choiceComposite, "Available Behaviors", 0);
        choiceLabel.setLayoutData((Object)new GridData(768));
        return choiceComposite;
    }

    @Override
    protected void newElementsSelected(Collection<?> newElements) {
        this.domain.getCommandStack().execute((Command)new ActivateBehaviorToolsCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(newElements, BehaviorTool.class))));
    }

    @Override
    protected void oldElementsRemoved(Collection<?> oldElements) {
        this.domain.getCommandStack().execute((Command)new DeactivateBehaviorToolsCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(oldElements, BehaviorTool.class))));
    }
}

