/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.ui.services.action.internal.contributionitem.IContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.DiagramCreationDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.ISiriusEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.CreateRepresentationFromRepresentationCreationDescription;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;

public class SubDiagramMenu
implements IContributionItemProvider {
    private static final String CREATE_REPRESENTATION_GROUP_SEPARATOR = "createRepresentationGroup";

    public void contributeToActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void contributeToPopupMenu(IMenuManager menu, IWorkbenchPart part) {
        SiriusDiagramEditor diagrampart;
        EditPart editpart;
        if (part instanceof SiriusDiagramEditor && (editpart = (diagrampart = (SiriusDiagramEditor)part).getDiagramGraphicalViewer().getFocusEditPart()) instanceof IGraphicalEditPart && !(editpart instanceof NoteEditPart)) {
            EObject target;
            IGraphicalEditPart curPart = (IGraphicalEditPart)editpart;
            EObject eObj = curPart.resolveSemanticElement();
            if (eObj instanceof DRepresentationElement && ((target = ((DRepresentationElement)eObj).getTarget()) == null || target.eResource() == null)) {
                return;
            }
            if (editpart instanceof ISiriusEditPart) {
                IMenuManager navigate = (IMenuManager)menu.find("navigateMenu");
                Separator createGroup = new Separator(CREATE_REPRESENTATION_GROUP_SEPARATOR);
                navigate.add((IContributionItem)createGroup);
                if (eObj instanceof DNode) {
                    this.createDetailsActions((DNode)eObj, navigate, diagrampart.getEditingDomain(), curPart);
                } else if (eObj instanceof DNodeListElement) {
                    this.createDetailsActions((DNodeListElement)eObj, navigate, diagrampart.getEditingDomain(), curPart);
                } else if (eObj instanceof DEdge) {
                    this.createDetailsActions((DEdge)eObj, navigate, diagrampart.getEditingDomain(), curPart);
                } else if (eObj instanceof DDiagramElementContainer) {
                    this.createDetailsActions((DDiagramElementContainer)eObj, navigate, diagrampart.getEditingDomain(), curPart);
                }
            }
        }
    }

    private void createDetailsActions(DDiagramElementContainer container, IMenuManager navigate, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        if (container.getActualMapping() != null) {
            for (RepresentationCreationDescription desc : container.getActualMapping().getDetailDescriptions()) {
                Session session;
                String precondition = desc.getPrecondition();
                boolean append = true;
                EList semanticElements = container.getSemanticElements();
                if (semanticElements != null && !semanticElements.isEmpty() && !this.isFromActiveSirius(session = SessionManager.INSTANCE.getSession((EObject)semanticElements.get(0)), desc.getRepresentationDescription())) {
                    append = false;
                }
                if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
                    append = false;
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)container);
                    try {
                        append = interpreter.evaluateBoolean(container.getTarget(), precondition);
                    }
                    catch (EvaluationException evaluationException) {}
                }
                if (!append) continue;
                navigate.appendToGroup(CREATE_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)container, editingDomain, curPart));
            }
        }
    }

    private void createDetailsActions(DNode viewNode, IMenuManager navigate, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        if (viewNode.getActualMapping() != null) {
            Iterator it = viewNode.getActualMapping().getDetailDescriptions().iterator();
            while (it.hasNext()) {
                Session session;
                RepresentationCreationDescription repCreation;
                RepresentationCreationDescription desc = repCreation = (RepresentationCreationDescription)it.next();
                String precondition = desc.getPrecondition();
                boolean append = true;
                EList semanticElements = viewNode.getSemanticElements();
                if (semanticElements != null && !semanticElements.isEmpty() && !this.isFromActiveSirius(session = SessionManager.INSTANCE.getSession((EObject)semanticElements.get(0)), desc.getRepresentationDescription())) {
                    append = false;
                }
                if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
                    append = false;
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)viewNode);
                    try {
                        append = interpreter.evaluateBoolean(viewNode.getTarget(), precondition);
                    }
                    catch (EvaluationException evaluationException) {}
                }
                if (!append) continue;
                navigate.appendToGroup(CREATE_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)viewNode, editingDomain, curPart));
            }
        }
    }

    private void createDetailsActions(DNodeListElement viewNodeListElement, IMenuManager navigate, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        if (viewNodeListElement.getActualMapping() != null) {
            for (RepresentationCreationDescription desc : viewNodeListElement.getActualMapping().getDetailDescriptions()) {
                Session session;
                String precondition = desc.getPrecondition();
                boolean append = true;
                EList semanticElements = viewNodeListElement.getSemanticElements();
                if (semanticElements != null && !semanticElements.isEmpty() && !this.isFromActiveSirius(session = SessionManager.INSTANCE.getSession((EObject)semanticElements.get(0)), desc.getRepresentationDescription())) {
                    append = false;
                }
                if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
                    append = false;
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)viewNodeListElement);
                    try {
                        append = interpreter.evaluateBoolean(viewNodeListElement.getTarget(), precondition);
                    }
                    catch (EvaluationException evaluationException) {}
                }
                if (!append) continue;
                navigate.appendToGroup(CREATE_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription(desc, (DRepresentationElement)viewNodeListElement, editingDomain, curPart));
            }
        }
    }

    private boolean isFromActiveSirius(Session session, RepresentationDescription description) {
        Viewpoint vp = ViewpointRegistry.getInstance().getViewpoint(description);
        return vp != null && session.getSelectedViewpoints(false).contains(vp);
    }

    private void createDetailsActions(DEdge viewedge, IMenuManager navigate, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        Option edgeMapping = new IEdgeMappingQuery(viewedge.getActualMapping()).getEdgeMapping();
        if (edgeMapping.some()) {
            for (RepresentationCreationDescription repCreation : ((EdgeMapping)edgeMapping.get()).getDetailDescriptions()) {
                Session session;
                if (!(repCreation instanceof DiagramCreationDescription)) continue;
                DiagramCreationDescription desc = (DiagramCreationDescription)repCreation;
                String precondition = desc.getPrecondition();
                boolean append = true;
                EList semanticElements = viewedge.getSemanticElements();
                if (semanticElements != null && !semanticElements.isEmpty()) {
                    session = SessionManager.INSTANCE.getSession((EObject)semanticElements.get(0));
                    if (!this.isFromActiveSirius(session, desc.getRepresentationDescription())) {
                        append = false;
                    }
                } else if (viewedge.getTarget() != null && !this.isFromActiveSirius(session = SessionManager.INSTANCE.getSession(viewedge.getTarget()), desc.getRepresentationDescription())) {
                    append = false;
                }
                if (precondition != null && !StringUtil.isEmpty((String)precondition.trim())) {
                    append = false;
                    IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)viewedge);
                    try {
                        append = interpreter.evaluateBoolean(viewedge.getTarget(), precondition);
                    }
                    catch (EvaluationException evaluationException) {}
                }
                if (!append) continue;
                navigate.appendToGroup(CREATE_REPRESENTATION_GROUP_SEPARATOR, (IAction)new CreateRepresentationFromRepresentationCreationDescription((RepresentationCreationDescription)desc, (DRepresentationElement)viewedge, editingDomain, curPart));
            }
        }
    }

    public void disposeContributions(IWorkbenchPartDescriptor arg0) {
    }

    public void updateActionBars(IActionBars arg0, IWorkbenchPartDescriptor arg1) {
    }

    public void addProviderChangeListener(IProviderChangeListener arg0) {
    }

    public boolean provides(IOperation arg0) {
        return true;
    }

    public void removeProviderChangeListener(IProviderChangeListener arg0) {
    }
}

