/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.listener.NotificationUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.business.api.helper.concern.ConcernService;
import org.eclipse.sirius.diagram.description.concern.ConcernDescription;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.diagram.ui.tools.internal.filter.FilterTools;

public final class ActivateFiltersCommand
extends RecordingCommand {
    private final Collection<FilterDescription> newElements;
    private final DDiagram diagram;

    public ActivateFiltersCommand(TransactionalEditingDomain domain, DDiagram diagram, Collection<FilterDescription> newElements) {
        super(domain, "Activate filters");
        this.newElements = newElements;
        this.diagram = diagram;
    }

    protected void doExecute() {
        if (this.diagram == null || this.newElements == null) {
            return;
        }
        this.initFilterVariablesHistory();
        this.doActivateFilters();
        if (this.newElements.size() > 0) {
            NotificationUtil.sendNotification((EObject)this.diagram, (int)0, (int)5);
        }
    }

    private void doActivateFilters() {
        boolean containsVariableFilters = false;
        ArrayList<FilterDescription> newActivatedFilters = new ArrayList<FilterDescription>();
        ArrayList previousActivatedFilters = new ArrayList(this.diagram.getActivatedFilters());
        ConcernDescription oldConcern = this.getAndResetConcern();
        try {
            for (FilterDescription filterDesc : this.newElements) {
                if (filterDesc instanceof CompositeFilterDescription && this.diagram instanceof DSemanticDiagram) {
                    containsVariableFilters |= this.handleVariableInit((CompositeFilterDescription)filterDesc, (DSemanticDiagram)this.diagram);
                }
                newActivatedFilters.add(filterDesc);
            }
            if (containsVariableFilters && previousActivatedFilters.size() > 0) {
                this.diagram.getActivatedFilters().clear();
            }
            this.diagram.getActivatedFilters().addAll(newActivatedFilters);
            if (containsVariableFilters && previousActivatedFilters.size() > 0) {
                this.diagram.getActivatedFilters().addAll(previousActivatedFilters);
            }
        }
        catch (InterruptedException interruptedException) {
            ConcernService.setCurrentConcern((DDiagram)this.diagram, (ConcernDescription)oldConcern);
        }
    }

    private ConcernDescription getAndResetConcern() {
        ConcernDescription oldConcern = null;
        if (this.newElements.size() > 0 && this.diagram.getCurrentConcern() != null) {
            oldConcern = this.diagram.getCurrentConcern();
            ConcernService.resetCurrentConcern((DDiagram)this.diagram);
        }
        return oldConcern;
    }

    private void initFilterVariablesHistory() {
        if (this.diagram.getFilterVariableHistory() == null) {
            this.diagram.setFilterVariableHistory(DiagramFactory.eINSTANCE.createFilterVariableHistory());
        }
    }

    private boolean handleVariableInit(CompositeFilterDescription composite, DSemanticDiagram vp) throws InterruptedException {
        boolean containsVariableFilters = false;
        for (Filter objFilter : composite.getFilters()) {
            if (!(objFilter instanceof VariableFilter)) continue;
            VariableFilter filter = (VariableFilter)objFilter;
            Map<String, EObject> variables = FilterTools.askForFilterValues(vp, filter);
            filter.setFilterContext(variables);
            containsVariableFilters = true;
        }
        return containsVariableFilters;
    }
}

