/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ui.tools.internal.actions.export.AbstractExportRepresentationsAction;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.PlatformUI;

public class SaveAsImageFileAction
extends AbstractExportRepresentationsAction {
    public SaveAsImageFileAction() {
        super("Export diagram as image", DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/screenshot.gif"));
        this.setId("newCopyToImageAction");
    }

    protected Collection<DRepresentation> getDRepresentationToExport() {
        DRepresentation dRepresentationToExport = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedObject : structuredSelection.toList()) {
                IDiagramElementEditPart ddePart;
                DDiagramElement dde;
                if (selectedObject instanceof IDDiagramEditPart) {
                    IDDiagramEditPart dDiagramEditPart = (IDDiagramEditPart)selectedObject;
                    Option<DDiagram> dDiagramOption = dDiagramEditPart.resolveDDiagram();
                    if (!dDiagramOption.some()) continue;
                    dRepresentationToExport = (DRepresentation)dDiagramOption.get();
                    break;
                }
                if (selectedObject instanceof IDiagramElementEditPart && (dde = (ddePart = (IDiagramElementEditPart)selectedObject).resolveDiagramElement()) != null && (dRepresentationToExport = dde.getParentDiagram()) != null) break;
            }
        }
        return dRepresentationToExport == null ? Collections.emptyList() : Collections.singleton(dRepresentationToExport);
    }

    protected Session getSession(DRepresentation representation) {
        Session session = null;
        if (representation != null) {
            EObjectQuery eObjectQuery = new EObjectQuery((EObject)representation);
            session = eObjectQuery.getSession();
        }
        return session;
    }
}

