/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.InitializeLayoutCommand;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.ui.tools.api.actions.AbstractCreateRepresentationFromRepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;

public class CreateRepresentationFromRepresentationCreationDescription
extends AbstractCreateRepresentationFromRepresentationCreationDescription {
    private final IGraphicalEditPart editPart;

    public CreateRepresentationFromRepresentationCreationDescription(RepresentationCreationDescription desc, DRepresentationElement target, TransactionalEditingDomain editingDomain, IGraphicalEditPart curPart) {
        super(desc, target, editingDomain, (ICommandFactory)CreateRepresentationFromRepresentationCreationDescription.getDiagramCommandFactory(curPart, editingDomain));
        this.editPart = curPart;
    }

    protected Option<DRepresentation> executeCreationCommand(Option<Command> initialOperationCommand, CreateRepresentationCommand createRepresentationCommand) {
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(this.getEditingDomain(), "Create and open representation");
        if (initialOperationCommand.some()) {
            compositeCommand.compose((IUndoableOperation)new GMFCommandWrapper(this.getEditingDomain(), (Command)initialOperationCommand.get()));
        }
        InitializeLayoutCommand layoutCommand = null;
        DRepresentation createdRepresentation = null;
        compositeCommand.compose((IUndoableOperation)new GMFCommandWrapper(this.getEditingDomain(), (Command)createRepresentationCommand));
        if (this.getTarget() != null) {
            layoutCommand = new InitializeLayoutCommand(this.getEditingDomain(), createRepresentationCommand, this.editPart);
            compositeCommand.compose((IUndoableOperation)new GMFCommandWrapper(this.getEditingDomain(), (Command)layoutCommand));
        }
        this.editPart.getRoot().getViewer().getEditDomain().getCommandStack().execute((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)compositeCommand));
        if (createRepresentationCommand.getCreatedRepresentation() != null) {
            createdRepresentation = createRepresentationCommand.getCreatedRepresentation();
        } else if (layoutCommand != null && layoutCommand.getLayoutedRepresentation() != null) {
            createdRepresentation = layoutCommand.getLayoutedRepresentation();
        }
        return Options.newSome((Object)createdRepresentation);
    }

    private static IDiagramCommandFactory getDiagramCommandFactory(IGraphicalEditPart curPart, TransactionalEditingDomain editingDomain) {
        DDiagramEditor diagramEditor = (DDiagramEditor)curPart.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        if (diagramEditor == null) {
            return null;
        }
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider diagramCmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory diagramCommandFactory = diagramCmdFactoryProvider.getCommandFactory(editingDomain);
        return diagramCommandFactory;
    }
}

