/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ITransparentFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.StyledFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.TransparentFigureGraphicsModifier;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;

public abstract class AbstractCachedSVGFigure
extends SVGFigure
implements StyledFigure,
ITransparentFigure {
    protected static final String SEPARATOR = "|";
    private static final Map<String, Image> SVG_IMG_CACHE = new MapMaker().softValues().makeMap();
    private static final String IMAGE_DIR = "images/";
    private static final String IMAGE_EXT = ".svg";
    private static final String IMAGE_NOT_FOUND = "NotFound";
    private int viewpointAlpha = 100;
    private boolean transparent;

    public AbstractCachedSVGFigure() {
        this.setLayoutManager((LayoutManager)new XYLayout());
    }

    @Override
    public int getSiriusAlpha() {
        return this.viewpointAlpha;
    }

    @Override
    public boolean isTransparent() {
        return this.transparent;
    }

    @Override
    public void setSiriusAlpha(int alpha) {
        this.viewpointAlpha = alpha;
    }

    @Override
    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        TransparentFigureGraphicsModifier modifier = new TransparentFigureGraphicsModifier(this, graphics);
        modifier.pushState();
        Rectangle r = this.getClientArea();
        Image image = this.getCachedImage(String.valueOf(this.getKey()) + this.getContextKey(graphics), r, graphics);
        if (image != null) {
            graphics.drawImage(image, r.x, r.y);
        }
        modifier.popState();
    }

    private String getContextKey(Graphics graphics) {
        int aaText = -1;
        try {
            aaText = graphics.getTextAntialias();
        }
        catch (Exception exception) {}
        StringBuilder result = new StringBuilder();
        result.append(aaText);
        result.append(SEPARATOR);
        Rectangle r = this.getClientArea();
        result.append(this.getSpecifyCanvasWidth() ? r.width : -1);
        result.append(SEPARATOR);
        result.append(this.getSpecifyCanvasHeight() ? r.height : -1);
        return result.toString();
    }

    protected Image getCachedImage(String key, Rectangle clientArea, Graphics graphics) {
        if (!SVG_IMG_CACHE.containsKey(key)) {
            Document document = this.getDocument();
            if (document == null) {
                return null;
            }
            this.getTranscoder().setCanvasSize(this.getSpecifyCanvasWidth() ? clientArea.width : -1, this.getSpecifyCanvasHeight() ? clientArea.height : -1);
            this.updateRenderingHints(graphics);
            BufferedImage awtImage = this.getTranscoder().getBufferedImage();
            if (awtImage != null) {
                SVG_IMG_CACHE.put(key, AbstractCachedSVGFigure.toSWT((Device)Display.getCurrent(), awtImage));
            }
        }
        return SVG_IMG_CACHE.get(key);
    }

    protected abstract String getKey();

    protected static String getImageNotFoundURI() {
        String path = new StringBuffer(IMAGE_DIR).append(IMAGE_NOT_FOUND).append(IMAGE_EXT).toString();
        String pluginId = DiagramUIPlugin.getPlugin().getSymbolicName();
        return "platform:/plugin/" + pluginId + "/" + path;
    }

    protected static boolean doRemoveFromCache(String documentKey) {
        if (!StringUtil.isEmpty((String)documentKey)) {
            boolean removedFromDocumentsMap;
            boolean remove = false;
            ArrayList keyToRemove = Lists.newArrayList();
            for (String key : SVG_IMG_CACHE.keySet()) {
                if (!key.startsWith(documentKey)) continue;
                keyToRemove.add(key);
            }
            for (String toRemove : keyToRemove) {
                SVG_IMG_CACHE.remove(toRemove);
                remove = true;
            }
            boolean bl = removedFromDocumentsMap = documentsMap.remove(documentKey) != null;
            return remove || removedFromDocumentsMap;
        }
        return false;
    }
}

