/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.BracketEdgeStyle;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.viewpoint.Style;

public class SiriusVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(DiagramUIPlugin.getPlugin().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Sirius".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return SiriusVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                DiagramPlugin.getDefault().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (DiagramPackage.eINSTANCE.getDDiagram().isSuperTypeOf(domainElement.eClass()) && SiriusVisualIDRegistry.isDiagram((DDiagram)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = SiriusVisualIDRegistry.getModelID(containerView);
        if (!"Sirius".equals(containerModelID)) {
            return -1;
        }
        if ("Sirius".equals(containerModelID)) {
            containerVisualID = SiriusVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 2001: {
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (DiagramPackage.eINSTANCE.getDot().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (DiagramPackage.eINSTANCE.getSquare().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (DiagramPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (DiagramPackage.eINSTANCE.getLozenge().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (DiagramPackage.eINSTANCE.getBundledImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (DiagramPackage.eINSTANCE.getNote().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (DiagramPackage.eINSTANCE.getWorkspaceImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (DiagramPackage.eINSTANCE.getGaugeCompositeStyle().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (!DiagramPackage.eINSTANCE.getCustomStyle().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 2002: {
                if (!DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 2003: {
                if (!DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 3001: {
                if (DiagramPackage.eINSTANCE.getBundledImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (DiagramPackage.eINSTANCE.getDot().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (DiagramPackage.eINSTANCE.getGaugeCompositeStyle().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (DiagramPackage.eINSTANCE.getSquare().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (DiagramPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (DiagramPackage.eINSTANCE.getLozenge().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (DiagramPackage.eINSTANCE.getWorkspaceImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (!DiagramPackage.eINSTANCE.getCustomStyle().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3007: {
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (DiagramPackage.eINSTANCE.getDot().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (DiagramPackage.eINSTANCE.getSquare().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (DiagramPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (DiagramPackage.eINSTANCE.getLozenge().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (DiagramPackage.eINSTANCE.getBundledImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (DiagramPackage.eINSTANCE.getNote().isSuperTypeOf(domainElement.eClass())) {
                    return 3013;
                }
                if (DiagramPackage.eINSTANCE.getWorkspaceImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (DiagramPackage.eINSTANCE.getGaugeCompositeStyle().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (!DiagramPackage.eINSTANCE.getCustomStyle().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 3008: {
                if (!DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 3009: {
                if (!DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) break;
                return 3012;
            }
            case 3012: {
                if (DiagramPackage.eINSTANCE.getBundledImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (DiagramPackage.eINSTANCE.getDot().isSuperTypeOf(domainElement.eClass())) {
                    return 3002;
                }
                if (DiagramPackage.eINSTANCE.getGaugeCompositeStyle().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (DiagramPackage.eINSTANCE.getSquare().isSuperTypeOf(domainElement.eClass())) {
                    return 3003;
                }
                if (DiagramPackage.eINSTANCE.getEllipse().isSuperTypeOf(domainElement.eClass())) {
                    return 3016;
                }
                if (DiagramPackage.eINSTANCE.getLozenge().isSuperTypeOf(domainElement.eClass())) {
                    return 3017;
                }
                if (DiagramPackage.eINSTANCE.getWorkspaceImage().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3012;
                }
                if (!DiagramPackage.eINSTANCE.getCustomStyle().isSuperTypeOf(domainElement.eClass())) break;
                return 3014;
            }
            case 7001: {
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (DiagramPackage.eINSTANCE.getDNodeContainer().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!DiagramPackage.eINSTANCE.getDNodeList().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7002: {
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (DiagramPackage.eINSTANCE.getDNodeContainer().isSuperTypeOf(domainElement.eClass())) {
                    return 3008;
                }
                if (!DiagramPackage.eINSTANCE.getDNodeList().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7003: {
                if (!DiagramPackage.eINSTANCE.getDNodeListElement().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7004: {
                if (!DiagramPackage.eINSTANCE.getDNodeListElement().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 1000: {
                if (DiagramPackage.eINSTANCE.getDNode().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (DiagramPackage.eINSTANCE.getDNodeContainer().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (!DiagramPackage.eINSTANCE.getDNodeList().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = SiriusVisualIDRegistry.getModelID(containerView);
        if (!"Sirius".equals(containerModelID)) {
            return false;
        }
        if ("Sirius".equals(containerModelID)) {
            containerVisualID = SiriusVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 2001: {
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3013 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7002 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (3012 != nodeVisualID) break;
                return true;
            }
            case 3012: {
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3002 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3003 == nodeVisualID) {
                    return true;
                }
                if (3016 == nodeVisualID) {
                    return true;
                }
                if (3017 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3012 == nodeVisualID) {
                    return true;
                }
                if (3014 != nodeVisualID) break;
                return true;
            }
            case 7001: 
            case 7002: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3008 == nodeVisualID) {
                    return true;
                }
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7003: 
            case 7004: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 == nodeVisualID) {
                    return true;
                }
                if (6003 == nodeVisualID) {
                    return true;
                }
                if (6002 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        int visualID = -1;
        if (domainElement != null && DiagramPackage.eINSTANCE.getDEdge().isSuperTypeOf(domainElement.eClass())) {
            DEdge dEdge = (DEdge)domainElement;
            Style style = dEdge.getStyle();
            visualID = style instanceof BracketEdgeStyle ? 4002 : 4001;
        }
        return visualID;
    }

    private static boolean isDiagram(DDiagram element) {
        return true;
    }
}

