/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.ComputedStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionRegistry;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public class ComputedStyleDescriptionCacheCleaner
extends ResourceSetListenerImpl {
    private DDiagram dDiagram;

    public ComputedStyleDescriptionCacheCleaner(TransactionalEditingDomain domain, DDiagram dDiagram) {
        domain.addResourceSetListener((ResourceSetListener)this);
        this.dDiagram = dDiagram;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand command = null;
        Set<StyleDescription> orphanedComputedStyleDescriptions = this.getOrphanedComputedStyleDescriptions(event.getNotifications());
        if (!orphanedComputedStyleDescriptions.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (StyleDescription orphanedComputedStyleDescription : orphanedComputedStyleDescriptions) {
                Command removeOrphanedComputedStyleDescriptionCmd = RemoveCommand.create((EditingDomain)this.getTarget(), (Object)orphanedComputedStyleDescription.eContainer(), (Object)DiagramPackage.Literals.COMPUTED_STYLE_DESCRIPTION_REGISTRY__COMPUTED_STYLE_DESCRIPTIONS, (Object)orphanedComputedStyleDescription);
                compoundCommand.append(removeOrphanedComputedStyleDescriptionCmd);
            }
            ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry = BestStyleDescriptionRegistry.getComputedStyleDescriptionRegistry((DDiagram)this.dDiagram, (boolean)false);
            if (computedStyleDescriptionRegistry != null) {
                this.addCmdsToCleanMaps(computedStyleDescriptionRegistry, orphanedComputedStyleDescriptions, compoundCommand);
            }
            if (!compoundCommand.isEmpty()) {
                command = compoundCommand;
            }
        }
        return command;
    }

    private void addCmdsToCleanMaps(ComputedStyleDescriptionRegistry computedStyleDescriptionRegistry, Collection<StyleDescription> orphanedComputedStyleDescriptions, CompoundCommand compoundCommand) {
        for (Map.Entry diagramElementMapping2ModelElementMapEntry : computedStyleDescriptionRegistry.getCache().entrySet()) {
            EMap modelElement2ViewVariableMap = (EMap)diagramElementMapping2ModelElementMapEntry.getValue();
            int nbModelElement2ViewVariableMapEntriesToRemove = 0;
            for (Map.Entry modelElement2ViewVariableMapEntry : modelElement2ViewVariableMap.entrySet()) {
                EMap viewVariable2ContainerVariableMap = (EMap)modelElement2ViewVariableMapEntry.getValue();
                int nbViewVariable2ContainerVariableMapEntriesToRemove = 0;
                for (Map.Entry viewVariable2ContainerVariableMapEntry : viewVariable2ContainerVariableMap.entrySet()) {
                    EMap containerVariable2StyleDescriptionMap = (EMap)viewVariable2ContainerVariableMapEntry.getValue();
                    int nbContainerVariable2StyleDescriptionMapEntriesToRemove = 0;
                    for (Map.Entry containerVariable2StyleDescriptionMapEntry : containerVariable2StyleDescriptionMap.entrySet()) {
                        StyleDescription value = (StyleDescription)containerVariable2StyleDescriptionMapEntry.getValue();
                        if (value != null && !orphanedComputedStyleDescriptions.contains(value)) continue;
                        RemoveMapEntryCommand removeMapEntryCmd = new RemoveMapEntryCommand(this.getTarget(), containerVariable2StyleDescriptionMap, containerVariable2StyleDescriptionMapEntry);
                        compoundCommand.append((Command)removeMapEntryCmd);
                        ++nbContainerVariable2StyleDescriptionMapEntriesToRemove;
                    }
                    if (containerVariable2StyleDescriptionMap.size() != nbContainerVariable2StyleDescriptionMapEntriesToRemove) continue;
                    RemoveMapEntryCommand removeMapEntryCmd = new RemoveMapEntryCommand(this.getTarget(), viewVariable2ContainerVariableMap, viewVariable2ContainerVariableMapEntry);
                    compoundCommand.append((Command)removeMapEntryCmd);
                    ++nbViewVariable2ContainerVariableMapEntriesToRemove;
                }
                if (viewVariable2ContainerVariableMap.size() != nbViewVariable2ContainerVariableMapEntriesToRemove) continue;
                RemoveMapEntryCommand removeMapEntryCmd = new RemoveMapEntryCommand(this.getTarget(), modelElement2ViewVariableMap, modelElement2ViewVariableMapEntry);
                compoundCommand.append((Command)removeMapEntryCmd);
                ++nbModelElement2ViewVariableMapEntriesToRemove;
            }
            if (modelElement2ViewVariableMap.size() != nbModelElement2ViewVariableMapEntriesToRemove) continue;
            RemoveMapEntryCommand removeMapEntryCmd = new RemoveMapEntryCommand(this.getTarget(), computedStyleDescriptionRegistry.getCache(), diagramElementMapping2ModelElementMapEntry);
            compoundCommand.append((Command)removeMapEntryCmd);
        }
    }

    private Set<StyleDescription> getOrphanedComputedStyleDescriptions(List<Notification> notifications) {
        HashSet<StyleDescription> orphanedComputedStyleDescriptions = new HashSet<StyleDescription>();
        for (Notification notification : notifications) {
            StyleDescription styleDescription;
            Style removedStyle = null;
            if (notification.getEventType() == 4 && notification.getOldValue() instanceof DDiagramElement) {
                DDiagramElement removedDDiagramElement = (DDiagramElement)notification.getOldValue();
                removedStyle = removedDDiagramElement.getStyle();
            } else if (notification.getEventType() == 1 && notification.getOldValue() instanceof Style) {
                removedStyle = (Style)notification.getOldValue();
            }
            if (removedStyle == null || removedStyle.getDescription() == null || (styleDescription = removedStyle.getDescription()).eContainingFeature() != DiagramPackage.Literals.COMPUTED_STYLE_DESCRIPTION_REGISTRY__COMPUTED_STYLE_DESCRIPTIONS || !this.concernCurrentDDiagram(notification)) continue;
            orphanedComputedStyleDescriptions.add(removedStyle.getDescription());
        }
        return orphanedComputedStyleDescriptions;
    }

    private boolean concernCurrentDDiagram(Notification notification) {
        boolean concernCurrentDDiagram = notification.getNotifier() instanceof EObject && this.dDiagram == new EObjectQuery((EObject)notification.getNotifier()).getParentDiagram().get();
        return concernCurrentDDiagram;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
        this.dDiagram = null;
    }

    final class RemoveMapEntryCommand
    extends RecordingCommand {
        private EMap<?, ?> map;
        private Map.Entry<?, ?> entry;

        public RemoveMapEntryCommand(TransactionalEditingDomain domain, EMap<?, ?> map, Map.Entry<?, ?> entry) {
            super(domain);
            this.map = map;
            this.entry = entry;
        }

        protected void doExecute() {
            this.map.remove(this.entry);
        }

        public void dispose() {
            this.map = null;
            this.entry = null;
            super.dispose();
        }
    }
}

