/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.borderednode;

import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CanonicalDBorderItemLocator {
    private static final int NB_SIDES = 4;
    private int preferredSide = 8;
    private Dimension borderItemOffset = new Dimension(1, 1);
    private Rectangle constraint = new Rectangle(0, 0, 0, 0);
    private Node container;
    private boolean borderItemHasMoved;
    private int currentSide = 8;

    public CanonicalDBorderItemLocator(Node containerNode, int preferredSide) {
        this.container = containerNode;
        this.preferredSide = preferredSide;
    }

    public void setBorderItemOffset(Dimension borderItemOffset) {
        this.borderItemOffset = borderItemOffset;
    }

    public Dimension getBorderItemOffset() {
        return this.borderItemOffset;
    }

    public void setConstraint(Rectangle constraint) {
        if (!constraint.equals((Object)this.getConstraint())) {
            this.borderItemHasMoved = true;
        }
        this.constraint = constraint;
        if (constraint.getTopLeft().x == 0 || constraint.getTopLeft().y == 0) {
            this.setCurrentSideOfParent(this.getPreferredSideOfParent());
        }
    }

    protected Rectangle getConstraint() {
        return this.constraint;
    }

    public void setCurrentSideOfParent(int side) {
        this.currentSide = side;
    }

    public int getPreferredSideOfParent() {
        return this.preferredSide;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int position;
        Point parentCenter = parentBorder.getCenter();
        Point childCenter = proposedLocation.getCenter();
        if (childCenter.x < parentCenter.x) {
            if (childCenter.y < parentCenter.y) {
                Point parentTopLeft = parentBorder.getTopLeft();
                position = childCenter.y < parentTopLeft.y ? 1 : (childCenter.x - parentTopLeft.x <= childCenter.y - parentTopLeft.y ? 8 : 1);
            } else {
                Point parentBottomLeft = parentBorder.getBottomLeft();
                position = childCenter.y > parentBottomLeft.y ? 4 : (childCenter.x - parentBottomLeft.x <= parentBottomLeft.y - childCenter.y ? 8 : 4);
            }
        } else if (childCenter.y < parentCenter.y) {
            Point parentTopRight = parentBorder.getTopRight();
            position = childCenter.y < parentTopRight.y ? 1 : (parentTopRight.x - childCenter.x <= childCenter.y - parentTopRight.y ? 16 : 1);
        } else {
            Point parentBottomRight = parentBorder.getBottomRight();
            position = childCenter.y > parentBottomRight.y ? 4 : (parentBottomRight.x - childCenter.x <= parentBottomRight.y - childCenter.y ? 16 : 4);
        }
        return position;
    }

    public void relocate(Node borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = new Rectangle(this.getPreferredLocation(borderItem), size);
        if (this.borderItemHasMoved) {
            int closestSide = CanonicalDBorderItemLocator.findClosestSideOfParent(rectSuggested, this.getParentBorder());
            this.setPreferredSideOfParent(closestSide);
            this.setCurrentSideOfParent(closestSide);
            this.borderItemHasMoved = false;
        }
    }

    private Point locateOnBorder(Rectangle suggestedLocation, int suggestedSide, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Point recommendedLocation = this.locateOnParent(suggestedLocation, suggestedSide, borderItem);
        Dimension nodeSize = suggestedLocation.getSize();
        if (circuitCount < 4 && this.conflicts(recommendedLocation, nodeSize, portsNodesToIgnore).some()) {
            Rectangle newRecommendedLocationBounds = new Rectangle(recommendedLocation, nodeSize);
            recommendedLocation = suggestedSide == 8 ? this.locateOnWestBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 4 ? this.locateOnSouthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : (suggestedSide == 16 ? this.locateOnEastBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore) : this.locateOnNorthBorder(newRecommendedLocationBounds, circuitCount, borderItem, portsNodesToIgnore)));
        }
        return recommendedLocation;
    }

    private Option<Rectangle> conflicts(Point recommendedLocation, Dimension nodeSize, Collection<Node> portsNodesToIgnore) {
        Rectangle recommendedRect = new Rectangle(recommendedLocation.x, recommendedLocation.y, nodeSize.width, nodeSize.height);
        EList borderItems = this.container.getPersistedChildren();
        ListIterator iterator = borderItems.listIterator();
        while (iterator.hasNext()) {
            LayoutConstraint borderItemLayoutConstraint;
            Node borderItem = (Node)iterator.next();
            boolean takeIntoAccount = true;
            ViewQuery viewQuery = new ViewQuery((View)borderItem);
            NodeQuery nodeQuery = new NodeQuery(borderItem);
            if (!nodeQuery.isBorderedNode() && !viewQuery.isForNameEditPartOnBorder()) {
                takeIntoAccount = false;
            }
            if (!this.isVisible(borderItem) || !takeIntoAccount || !((borderItemLayoutConstraint = borderItem.getLayoutConstraint()) instanceof Bounds)) continue;
            Dimension extendedDimension = this.getExtendedDimension(borderItem);
            Rectangle borderItemBounds = GMFHelper.getAbsoluteBounds(borderItem);
            if (extendedDimension != null) {
                borderItemBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, borderItemBounds, this.getParentBorder());
            }
            if (portsNodesToIgnore.contains(borderItem) || !borderItemBounds.intersects(recommendedRect)) continue;
            return Options.newSome((Object)borderItemBounds);
        }
        return Options.newNone();
    }

    private boolean isVisible(Node node) {
        EObject element = node.getElement();
        if (element instanceof DDiagramElement) {
            return ((DDiagramElement)element).isVisible() && node.isVisible();
        }
        return node.isVisible();
    }

    private Dimension getExtendedDimension(Node node) {
        DDiagramElementQuery diagramElementQuery;
        if (node.getElement() instanceof DDiagramElement && (diagramElementQuery = new DDiagramElementQuery((DDiagramElement)node.getElement())).isCollapsed()) {
            NodeQuery nodeQuery = new NodeQuery(node);
            return nodeQuery.getOriginalDimensionBeforeCollapse();
        }
        return null;
    }

    protected Point locateOnParent(Rectangle suggestedLocation, int suggestedSide, Node borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = suggestedLocation.getSize();
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX - borderItemSize.width + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height;
        int northY = parentFigureY - borderItemSize.height + this.getBorderItemOffset().height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.y != northY) {
                newY = northY;
            }
            if (borderItemSize.width > bounds.width) {
                newX = parentFigureX - (borderItemSize.width - bounds.width) / 2;
            } else if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        }
        return new Point(newX, newY);
    }

    protected Point locateOnSouthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForEast = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForEast = new Point(rightTestPoint.x + rightVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                        }
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForEast, borderItemSize), 16, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnNorthBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point rightTestPoint = recommendedLocation.getLocation();
        Point leftTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceToTheRight = true;
        boolean isStillFreeSpaceToTheLeft = true;
        int rightVerticalGap = 0;
        int leftVerticalGap = 0;
        Point recommendedLocationForWest = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceToTheRight || isStillFreeSpaceToTheLeft)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceToTheRight) {
                rightTestPoint.x += rightVerticalGap;
                optionalConflictingRectangle = this.conflicts(rightTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    rightVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).x + ((Rectangle)optionalConflictingRectangle.get()).width + 1 - rightTestPoint.x;
                    if (rightTestPoint.x + rightVerticalGap + borderItemSize.width > this.getParentBorder().getBottomRight().x) {
                        isStillFreeSpaceToTheRight = false;
                    }
                } else {
                    resultLocation = rightTestPoint;
                }
            }
            if (!isStillFreeSpaceToTheLeft || resultLocation != null) continue;
            leftTestPoint.x -= leftVerticalGap;
            optionalConflictingRectangle = this.conflicts(leftTestPoint, borderItemSize, portsNodesToIgnore);
            if (optionalConflictingRectangle.some()) {
                leftVerticalGap = leftTestPoint.x - (((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1);
                if (leftTestPoint.x - leftVerticalGap >= this.getParentBorder().getTopLeft().x) continue;
                isStillFreeSpaceToTheLeft = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForWest = new Point(leftTestPoint.x - leftVerticalGap, ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height + 1);
                continue;
            }
            resultLocation = leftTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForWest, borderItemSize), 8, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnWestBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForSouth = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                        if (circuitCount == 3) {
                            resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                        } else {
                            recommendedLocationForSouth = new Point(belowTestPoint.x + ((Rectangle)optionalConflictingRectangle.get()).width + 1, belowTestPoint.y + belowVerticalGap);
                        }
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForSouth, borderItemSize), 4, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    protected Point locateOnEastBorder(Rectangle recommendedLocation, int circuitCount, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Dimension borderItemSize = recommendedLocation.getSize();
        Point resultLocation = null;
        Point belowTestPoint = recommendedLocation.getLocation();
        Point aboveTestPoint = recommendedLocation.getLocation();
        boolean isStillFreeSpaceAbove = true;
        boolean isStillFreeSpaceBelow = true;
        int belowVerticalGap = 0;
        int aboveVerticalGap = 0;
        Point recommendedLocationForNorth = recommendedLocation.getLocation();
        while (resultLocation == null && (isStillFreeSpaceAbove || isStillFreeSpaceBelow)) {
            Option<Rectangle> optionalConflictingRectangle;
            if (isStillFreeSpaceBelow) {
                belowTestPoint.y += belowVerticalGap;
                optionalConflictingRectangle = this.conflicts(belowTestPoint, borderItemSize, portsNodesToIgnore);
                if (optionalConflictingRectangle.some()) {
                    belowVerticalGap = ((Rectangle)optionalConflictingRectangle.get()).y + ((Rectangle)optionalConflictingRectangle.get()).height - belowTestPoint.y + 1;
                    if (belowTestPoint.y + belowVerticalGap + borderItemSize.height > this.getParentBorder().getBottomLeft().y) {
                        isStillFreeSpaceBelow = false;
                    }
                } else {
                    resultLocation = belowTestPoint;
                }
            }
            if (!isStillFreeSpaceAbove || resultLocation != null) continue;
            aboveTestPoint.y -= aboveVerticalGap;
            optionalConflictingRectangle = this.conflicts(aboveTestPoint, borderItemSize, portsNodesToIgnore);
            if (optionalConflictingRectangle.some()) {
                aboveVerticalGap = aboveTestPoint.y - (((Rectangle)optionalConflictingRectangle.get()).y - borderItemSize.height - 1);
                if (aboveTestPoint.y - aboveVerticalGap >= this.getParentBorder().getTopRight().y) continue;
                isStillFreeSpaceAbove = false;
                if (circuitCount == 3) {
                    resultLocation = ((Rectangle)optionalConflictingRectangle.get()).getTopLeft();
                    continue;
                }
                recommendedLocationForNorth = new Point(((Rectangle)optionalConflictingRectangle.get()).x - borderItemSize.width - 1, aboveTestPoint.y - aboveVerticalGap);
                continue;
            }
            resultLocation = aboveTestPoint;
        }
        if (resultLocation == null) {
            resultLocation = this.locateOnBorder(new Rectangle(recommendedLocationForNorth, borderItemSize), 1, circuitCount + 1, borderItem, portsNodesToIgnore);
        }
        return resultLocation;
    }

    public void setPreferredSideOfParent(int preferredSide) {
        this.preferredSide = preferredSide;
        this.setCurrentSideOfParent(preferredSide);
    }

    private Point getPreferredLocation(Node borderItem) {
        Point constraintLocation = this.getConstraint().getLocation();
        Point ptAbsoluteLocation = this.getAbsoluteToBorder(constraintLocation);
        return ptAbsoluteLocation;
    }

    public int getCurrentSideOfParent() {
        return this.currentSide;
    }

    private Point getAbsoluteToBorder(Point ptRelativeOffset) {
        Point parentOrigin = this.getParentBorder().getTopLeft();
        return parentOrigin.translate(ptRelativeOffset);
    }

    private Rectangle getParentBorder() {
        NodeQuery nodeQuery = new NodeQuery(this.container);
        return nodeQuery.getHandleBounds();
    }

    private Dimension getSize(Node borderItem) {
        return GMFHelper.getBounds(borderItem).getSize();
    }

    public Point getValidLocation(Rectangle proposedBounds, Node borderItem, Collection<Node> portsNodesToIgnore) {
        Rectangle realBounds = new Rectangle(proposedBounds);
        Dimension oldOffset = this.getBorderItemOffset();
        NodeQuery nodeQuery = new NodeQuery(borderItem);
        boolean isCollapsed = nodeQuery.isCollapsed();
        if (isCollapsed) {
            Dimension extendedDimension = nodeQuery.getOriginalDimensionBeforeCollapse();
            this.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            if (extendedDimension.height != proposedBounds.height || extendedDimension.width != proposedBounds.width) {
                Rectangle extendedBounds = PortLayoutHelper.getUncollapseCandidateLocation(extendedDimension, proposedBounds, this.getParentBorder());
                realBounds.setBounds(extendedBounds);
            }
        }
        int side = CanonicalDBorderItemLocator.findClosestSideOfParent(proposedBounds, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realBounds, side, 0, borderItem, portsNodesToIgnore);
        if (isCollapsed) {
            this.setBorderItemOffset(oldOffset);
            Rectangle collapsedBounds = PortLayoutHelper.getCollapseCandidateLocation(nodeQuery.getCollapsedSize(), new Rectangle(newTopLeft, nodeQuery.getOriginalDimensionBeforeCollapse()), this.getParentBorder());
            newTopLeft = collapsedBounds.getLocation();
        }
        return newTopLeft;
    }
}

