/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.business.internal.edit.helpers.LabelAlignmentHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.DiagramNameEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.ListItemDeletionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractGeneratedDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DNodeListElementItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.SiriusTextNonResizableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusParserProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.LabelAlignment;

public class DNodeListElementEditPart
extends AbstractGeneratedDiagramNameEditPart
implements ITextAwareEditPart {
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    private NotificationPreCommitListener adapterSemanticElements;
    public static final int VISUAL_ID = 3010;

    public DNodeListElementEditPart(View view) {
        super(view);
    }

    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("SemanticPolicy");
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DNodeListElementItemSemanticEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new SiriusTextNonResizableEditPolicy());
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        this.removeEditPolicy("ComponentEditPolicy");
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ListItemDeletionEditPolicy(this.getEditingDomain()));
    }

    @Override
    public void setLabel(IFigure figure) {
        this.unregisterVisuals();
        this.setFigure(figure);
        this.defaultText = this.getLabelTextHelper(figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    @Override
    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public IParser getParser() {
        if (this.parser == null) {
            String parserHint = ((View)this.getModel()).getType();
            SiriusParserProvider.HintAdapter hintAdapter = new SiriusParserProvider.HintAdapter(SiriusElementTypes.DNodeListElement_3010, this.getParserElement(), parserHint);
            this.parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        }
        return this.parser;
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabelAlignment();
    }

    private void refreshLabelAlignment() {
        IFigure parentFigure;
        DDiagramElement diagElement = this.resolveDiagramElement();
        if (diagElement != null && (parentFigure = this.getFigure().getParent()) != null && parentFigure.getLayoutManager() instanceof ConstrainedToolbarLayout) {
            ConstrainedToolbarLayout ctl = (ConstrainedToolbarLayout)parentFigure.getLayoutManager();
            LabelAlignment alignment = LabelAlignmentHelper.getLabelAlignementFor(diagElement);
            ctl.setMinorAlignment(LabelAlignmentHelper.getAsCTLMinorAlignment(alignment));
        }
    }

    @Override
    protected void refreshFont() {
    }

    @Override
    protected void refreshFontColor() {
    }

    protected void refreshForegroundColor() {
        DiagramNameEditPartOperation.refreshFont(this);
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null && (element = ((IGraphicalEditPart)styleEditPart).resolveSemanticElement()) != null && element.eResource() != null) {
            styleEditPart.refresh();
        }
        if ((element = this.resolveSemanticElement()) != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        Object feature = notification.getFeature();
        if (DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle() == feature) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(notification);
        if (notification.getEventType() == 1 || notification.getEventType() == 2 || notification.getEventType() == 3) {
            this.refresh();
        }
    }

    protected IFigure createFigure() {
        IFigure label = this.createFigurePrim();
        this.defaultText = this.getLabelTextHelper(label);
        return label;
    }

    protected IFigure createFigurePrim() {
        SiriusWrapLabel safeWrapLabel = new SiriusWrapLabel();
        safeWrapLabel.setTextWrap(true);
        return safeWrapLabel;
    }

    public void activate() {
        if (!this.isActive()) {
            IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
            auth.addAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
            super.activate();
            DiagramElementEditPartOperation.activate(this);
        }
        this.getEditPartAuthorityListener().refreshEditMode();
    }

    public void enableEditMode() {
        if (!this.getEditPartAuthorityListener().isLocked()) {
            super.enableEditMode();
        }
    }

    public void deactivate() {
        DiagramElementEditPartOperation.deactivate(this);
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        if (this.isActive()) {
            super.deactivate();
        }
    }

    public List getSemanticElements() {
        View view = (View)this.getModel();
        EObject viewpointElement = view.getElement();
        if (viewpointElement instanceof DDiagramElement) {
            List semanticElements = Collections.unmodifiableList(((DDiagramElement)viewpointElement).getSemanticElements());
            return semanticElements;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    @Override
    public NotificationPreCommitListener getEAdapterSemanticElements() {
        if (this.adapterSemanticElements == null) {
            this.adapterSemanticElements = DiagramElementEditPartOperation.createEAdpaterSemanticElements(this);
        }
        return this.adapterSemanticElements;
    }
}

