/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import java.util.List;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationPreCommitListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramEdgeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.EditStatusUpdater;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.DEdgeSelectionFeedbackEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.EdgeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies.SiriusConnectionEndPointEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.SiriusBendpointConnectionRouter;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDiagramEdgeEditPart
extends ConnectionNodeEditPart
implements IDiagramEdgeEditPart {
    private static final int SOURCE_TARGET_MINIMUM_SIZE_SELECTION = 20;
    private static final BendpointConnectionRouter ROUTER = new SiriusBendpointConnectionRouter();
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    private NotificationListener adapterDiagramElement;
    private NotificationPreCommitListener adapterSemanticElements;
    private NotificationPreCommitListener adapterRoutingStyle;
    private NotificationPreCommitListener adapterStrokeColor;
    private NotificationListener editModeListener = new EditStatusUpdater(this);

    public AbstractDiagramEdgeEditPart(View view) {
        super(view);
    }

    protected void registerModel() {
        super.registerModel();
        DiagramElementEditPartOperation.registerModel(this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        DiagramElementEditPartOperation.unregisterModel(this);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("Connection Endpoint Policy");
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new SiriusConnectionEndPointEditPolicy());
        this.removeEditPolicy("PropertyHandlerPolicy");
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
        CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
        compoundEditPolicy.addEditPolicy((EditPolicy)new EdgeCreationEditPolicy());
        if (this.getEditPolicy("ConnectionEditPolicy") != null) {
            compoundEditPolicy.addEditPolicy(this.getEditPolicy("ConnectionEditPolicy"));
            this.removeEditPolicy("ConnectionEditPolicy");
        }
        this.installEditPolicy("ConnectionEditPolicy", compoundEditPolicy);
        this.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        EditPolicy currentSelectionEditPolicy = this.getEditPolicy("Selection Feedback");
        DEdgeSelectionFeedbackEditPolicy selectionFeedBackEditPolicy = new DEdgeSelectionFeedbackEditPolicy();
        if (currentSelectionEditPolicy != null) {
            CompoundEditPolicy selectionCompoundEditPolicy = new CompoundEditPolicy();
            selectionCompoundEditPolicy.addEditPolicy(currentSelectionEditPolicy);
            selectionCompoundEditPolicy.addEditPolicy((EditPolicy)selectionFeedBackEditPolicy);
            this.removeEditPolicy("Selection Feedback");
            this.installEditPolicy("Selection Feedback", selectionCompoundEditPolicy);
        } else {
            this.installEditPolicy("Selection Feedback", (EditPolicy)selectionFeedBackEditPolicy);
        }
    }

    public Command getCommand(Request request) {
        Command cmd = super.getCommand(request);
        return CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
    }

    protected void handleNotificationEvent(Notification notification) {
        EObject element;
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null && (element = ((IGraphicalEditPart)styleEditPart).resolveSemanticElement()) != null && element.eResource() != null) {
            styleEditPart.refresh();
        }
        if ((element = this.resolveSemanticElement()) != null && element.eResource() != null && this.getParent() != null) {
            this.refresh();
        }
        if (this.resolveSemanticElement() instanceof DEdge) {
            super.handleNotificationEvent(notification);
        }
    }

    @Override
    public PolylineConnectionEx getPolylineConnectionFigure() {
        Connection connection = this.getConnectionFigure();
        if (connection instanceof PolylineConnectionEx) {
            return (PolylineConnectionEx)connection;
        }
        throw new IllegalStateException();
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        DiagramEdgeEditPartOperation.refreshVisuals(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramEdgeEditPartOperation.refreshFont(this);
    }

    protected void refreshBendpoints() {
        DEdge edge = this.getEdgeWithPath();
        if (edge == null) {
            super.refreshBendpoints();
        } else {
            DiagramEdgeEditPartOperation.refreshBendpointsWithPath(this, edge);
        }
    }

    private DEdge getEdgeWithPath() {
        DEdge edge;
        EObject semanticElement = this.resolveSemanticElement();
        if (semanticElement instanceof DEdge && (edge = (DEdge)semanticElement).getPath() != null && !edge.getPath().isEmpty()) {
            return edge;
        }
        return null;
    }

    @Override
    public void refreshForegroundColor() {
        if (!DiagramEdgeEditPartOperation.isSelected((EditPart)this) && !DiagramEdgeEditPartOperation.isLabelSelected(this)) {
            super.refreshForegroundColor();
            DiagramEdgeEditPartOperation.refreshForegroundColor(this);
        }
    }

    @Override
    public void refreshSourceDecoration() {
        DiagramEdgeEditPartOperation.refreshSourceDecoration(this);
    }

    @Override
    public void refreshTargetDecoration() {
        DiagramEdgeEditPartOperation.refreshTargetDecoration(this);
    }

    @Override
    public void refreshLineStyle() {
        DiagramEdgeEditPartOperation.refreshLineStyle(this);
    }

    @Override
    public NotificationListener getEAdapterDiagramElement() {
        if (this.adapterDiagramElement == null) {
            this.adapterDiagramElement = DiagramElementEditPartOperation.createEApdaterDiagramElement(this);
        }
        return this.adapterDiagramElement;
    }

    @Override
    public NotificationPreCommitListener getEAdapterSemanticElements() {
        if (this.adapterSemanticElements == null) {
            this.adapterSemanticElements = DiagramElementEditPartOperation.createEAdpaterSemanticElements(this);
        }
        return this.adapterSemanticElements;
    }

    @Override
    public NotificationListener getEditModeListener() {
        return this.editModeListener;
    }

    @Override
    public NotificationPreCommitListener getEAdapterRoutingStyle() {
        if (this.adapterRoutingStyle == null) {
            this.adapterRoutingStyle = DiagramEdgeEditPartOperation.createEAdapterRoutingStyle(this);
        }
        return this.adapterRoutingStyle;
    }

    @Override
    public NotificationPreCommitListener getEAdapterStrokeColor() {
        if (this.adapterStrokeColor == null) {
            this.adapterStrokeColor = DiagramEdgeEditPartOperation.createEAdapterStrokeColor(this);
        }
        return this.adapterStrokeColor;
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    @Override
    public Class<?> getMetamodelType() {
        return DEdge.class;
    }

    @Override
    public IStyleEditPart getStyleEditPart() {
        return DiagramElementEditPartOperation.getStyleEditPart(this);
    }

    @Override
    public List<EObject> resolveAllSemanticElements() {
        return DiagramElementEditPartOperation.resolveAllSemanticElements(this);
    }

    @Override
    public DDiagramElement resolveDiagramElement() {
        return DiagramElementEditPartOperation.resolveDiagramElement(this);
    }

    @Override
    public EObject resolveTargetSemanticElement() {
        return DiagramElementEditPartOperation.resolveTargetSemanticElement(this);
    }

    @Override
    public void routingStyleChanged(Notification message) {
        DiagramEdgeEditPartOperation.routingStyleChanged(this, message);
    }

    public void activate() {
        EObject element;
        if (!this.isActive() && (element = this.resolveSemanticElement()) instanceof DEdge) {
            super.activate();
            DiagramElementEditPartOperation.activate(this);
            DiagramEdgeEditPartOperation.activate(this);
        }
        this.installRouter();
    }

    public void deactivate() {
        if (this.isActive()) {
            DiagramEdgeEditPartOperation.deactivate(this);
            DiagramElementEditPartOperation.deactivate(this);
            super.deactivate();
        }
    }

    public void enableEditMode() {
        if (!this.authListener.isLocked()) {
            super.enableEditMode();
        }
    }

    protected void installRouter() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            DEdge edge = (DEdge)element;
            if (edge.getPath() != null && !edge.getPath().isEmpty()) {
                this.getPolylineConnectionFigure().setConnectionRouter((ConnectionRouter)ROUTER);
            } else {
                super.installRouter();
            }
        }
    }

    protected void refreshRoutingStyles() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            super.refreshRoutingStyles();
        }
    }

    protected void refreshRouterChange() {
        EObject element = this.resolveSemanticElement();
        if (element instanceof DEdge) {
            super.refreshRouterChange();
        }
    }

    @Override
    public Image getLabelIcon() {
        return DiagramElementEditPartOperation.getLabelIcon(this);
    }

    protected Connection createConnectionFigure() {
        return new ViewEdgeFigure();
    }

    private static boolean invalidPath(AbstractDiagramEdgeEditPart editPart, DEdge edge) {
        return true;
    }

    public void performRequest(Request request) {
        if (request instanceof DirectEditRequest || "direct edit".equals(request.getType())) {
            this.performDirectEditRequest(request);
        } else {
            super.performRequest(request);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        EditPart result = null;
        AbstractToolDescription tool = null;
        if (request instanceof CreateRequest && !(request instanceof CreateUnspecifiedTypeConnectionRequest) && ((CreateRequest)request).getNewObject() instanceof AbstractToolDescription) {
            tool = (AbstractToolDescription)((CreateRequest)request).getNewObject();
        }
        if (tool instanceof RequestDescription || tool instanceof SelectionWizardDescription || tool instanceof PaneBasedSelectionWizardDescription) {
            return this;
        }
        if (request instanceof SelectionRequest) {
            Point location;
            Rectangle rectWithMarges;
            int verticalIncrement;
            int horizontalIncrement;
            if (this.getSource() instanceof AbstractBorderItemEditPart) {
                IFigure sourceFigure = ((AbstractBorderItemEditPart)this.getSource()).getFigure();
                horizontalIncrement = 20 > sourceFigure.getSize().width ? 20 - sourceFigure.getSize().width : 0;
                verticalIncrement = 20 > sourceFigure.getSize().height ? 20 - sourceFigure.getSize().height : 0;
                rectWithMarges = sourceFigure.getBounds().getExpanded(horizontalIncrement, verticalIncrement);
                sourceFigure.translateToAbsolute((Translatable)rectWithMarges);
                location = ((SelectionRequest)request).getLocation();
                if (location != null && rectWithMarges.contains(location)) {
                    result = this.getSource();
                }
            }
            if (result == null && this.getTarget() instanceof AbstractBorderItemEditPart) {
                IFigure targetFigure = ((AbstractBorderItemEditPart)this.getTarget()).getFigure();
                horizontalIncrement = 20 > targetFigure.getSize().width ? 20 - targetFigure.getSize().width : 0;
                verticalIncrement = 20 > targetFigure.getSize().height ? 20 - targetFigure.getSize().height : 0;
                rectWithMarges = targetFigure.getBounds().getExpanded(horizontalIncrement, verticalIncrement);
                targetFigure.translateToAbsolute((Translatable)rectWithMarges);
                location = ((SelectionRequest)request).getLocation();
                if (location != null && rectWithMarges.contains(((SelectionRequest)request).getLocation())) {
                    result = this.getTarget();
                }
            }
        }
        if (result == null) {
            result = super.getTargetEditPart(request);
        }
        return result;
    }

    public class ViewEdgeFigure
    extends PolylineConnectionEx
    implements ITreeConnection {
        private SiriusWrapLabel fFigureViewEdgeNameFigure;
        private SiriusWrapLabel fFigureViewEdgeBeginNameFigure;
        private SiriusWrapLabel fFigureViewEdgeEndNameFigure;

        public ViewEdgeFigure() {
            this.createContents();
        }

        private void createContents() {
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            this.createCenterLabelFigure(element);
            this.createBeginLabelFigure(element);
            this.createEndLabelFigure(element);
        }

        private void createCenterLabelFigure(EObject element) {
            this.fFigureViewEdgeNameFigure = new SiriusWrapLabel();
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeNameFigure.setText(edge.getName());
                this.fFigureViewEdgeNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getName()));
            } else {
                this.fFigureViewEdgeNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeNameFigure.setLabelAlignment(2);
            this.fFigureViewEdgeNameFigure.setTextWrap(true);
            this.fFigureViewEdgeNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeNameFigure);
        }

        private void createBeginLabelFigure(EObject element) {
            this.fFigureViewEdgeBeginNameFigure = new SiriusWrapLabel();
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeBeginNameFigure.setText(edge.getBeginLabel());
                this.fFigureViewEdgeBeginNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getBeginLabel()));
            } else {
                this.fFigureViewEdgeBeginNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeBeginNameFigure.setLabelAlignment(1);
            this.fFigureViewEdgeBeginNameFigure.setTextWrap(true);
            this.fFigureViewEdgeBeginNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeBeginNameFigure);
        }

        private void createEndLabelFigure(EObject element) {
            this.fFigureViewEdgeEndNameFigure = new SiriusWrapLabel();
            if (element instanceof DEdge) {
                DEdge edge = (DEdge)element;
                this.fFigureViewEdgeEndNameFigure.setText(edge.getEndLabel());
                this.fFigureViewEdgeEndNameFigure.setVisible(!StringUtil.isEmpty((String)edge.getEndLabel()));
            } else {
                this.fFigureViewEdgeEndNameFigure.setVisible(false);
            }
            this.fFigureViewEdgeEndNameFigure.setLabelAlignment(2);
            this.fFigureViewEdgeEndNameFigure.setTextWrap(true);
            this.fFigureViewEdgeEndNameFigure.setTextWrapAlignment(2);
            this.add((IFigure)this.fFigureViewEdgeEndNameFigure);
        }

        public void layout() {
            if (!AbstractDiagramEdgeEditPart.this.isActive()) {
                return;
            }
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element)) {
                DEdge edge = (DEdge)element;
                boolean needRefreshVisuals = false;
                if (edge.getPath() != null && !edge.getPath().isEmpty() && AbstractDiagramEdgeEditPart.invalidPath(AbstractDiagramEdgeEditPart.this, edge) && AbstractDiagramEdgeEditPart.this.getSelected() != 2) {
                    needRefreshVisuals = true;
                }
                if (needRefreshVisuals || edge.isIsMockEdge()) {
                    AbstractDiagramEdgeEditPart.this.refreshVisuals();
                }
                if (this.getBounds() != null && AbstractDiagramEdgeEditPart.this.getSource() != null && AbstractDiagramEdgeEditPart.this.getTarget() != null) {
                    super.layout();
                }
                if (edge.getName() == null || StringUtil.isEmpty((String)edge.getName())) {
                    this.fFigureViewEdgeNameFigure.setVisible(false);
                }
                if (!(edge.getName() == null || StringUtil.isEmpty((String)edge.getName()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeNameFigure.isVisible())) {
                    this.fFigureViewEdgeNameFigure.setVisible(true);
                }
                if (edge.getEndLabel() == null || StringUtil.isEmpty((String)edge.getEndLabel())) {
                    this.fFigureViewEdgeEndNameFigure.setVisible(false);
                }
                if (!(edge.getEndLabel() == null || StringUtil.isEmpty((String)edge.getEndLabel()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeEndNameFigure.isVisible())) {
                    this.fFigureViewEdgeEndNameFigure.setVisible(true);
                }
                if (edge.getBeginLabel() == null || StringUtil.isEmpty((String)edge.getBeginLabel())) {
                    this.fFigureViewEdgeBeginNameFigure.setVisible(false);
                }
                if (!(edge.getBeginLabel() == null || StringUtil.isEmpty((String)edge.getBeginLabel()) || new DDiagramElementQuery((DDiagramElement)edge).isLabelHidden() || this.fFigureViewEdgeBeginNameFigure.isVisible())) {
                    this.fFigureViewEdgeBeginNameFigure.setVisible(true);
                }
            }
        }

        public void paintFigure(Graphics graphics) {
            DEdge viewEdge;
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element) && !(viewEdge = (DEdge)element).isIsMockEdge() && viewEdge.isVisible()) {
                super.paintFigure(graphics);
            }
        }

        protected void paintChildren(Graphics graphics) {
            DEdge viewEdge;
            EObject element = AbstractDiagramEdgeEditPart.this.resolveSemanticElement();
            if (element != null && DEdge.class.isInstance(element) && (viewEdge = (DEdge)element).isVisible()) {
                super.paintChildren(graphics);
            }
        }

        public SiriusWrapLabel getFigureViewEdgeNameFigure() {
            return this.fFigureViewEdgeNameFigure;
        }

        public SiriusWrapLabel getFigureViewBeginEdgeNameFigure() {
            return this.fFigureViewEdgeBeginNameFigure;
        }

        public SiriusWrapLabel getFigureViewEndEdgeNameFigure() {
            return this.fFigureViewEdgeEndNameFigure;
        }

        public RotatableDecoration getSourceDecoration() {
            return super.getSourceDecoration();
        }

        public RotatableDecoration getTargetDecoration() {
            return super.getTargetDecoration();
        }

        public String getHint() {
            if (AbstractDiagramEdgeEditPart.this.getTarget() != null) {
                return AbstractDiagramEdgeEditPart.this.getTarget().toString();
            }
            return "base";
        }

        public ITreeConnection.Orientation getOrientation() {
            return ITreeConnection.Orientation.VERTICAL;
        }

        public IGraphicalEditPart getEditPart() {
            return AbstractDiagramEdgeEditPart.this;
        }
    }
}

