/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.view;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.ObjectAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.IInternalLayoutRunnable;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.layout.LayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.LayoutService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.AbstractLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLabelLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.EdgeLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.business.internal.view.SiriusLayoutDataFlusher;
import org.eclipse.sirius.diagram.ui.graphical.figures.SiriusLayoutHelper;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class SiriusLayoutDataManagerImpl
implements SiriusLayoutDataManager {
    private static final String ARRANGE_COMMAND_LABEL = "Arrange created views";
    private static final Adapter LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter LAYOUT_MARKER_ADAPTER_ON_OPENING = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    private static final Adapter CENTER_LAYOUT_MARKER_ADAPTER = new Adapter(){

        public void setTarget(Notifier newTarget) {
        }

        public void notifyChanged(Notification notification) {
        }

        public boolean isAdapterForType(Object type) {
            return type instanceof SiriusLayoutDataManager;
        }

        public Notifier getTarget() {
            return null;
        }
    };
    List<AbstractLayoutData> rootsLayoutData = new ArrayList<AbstractLayoutData>();
    Predicate<View> predicate = new Predicate<View>(){

        public boolean apply(View input) {
            return SiriusLayoutDataManagerImpl.this.hasToArrange(input);
        }
    };
    private Map<Diagram, Set<View>> createdViewToLayout = new HashMap<Diagram, Set<View>>();
    private IOperationHistoryListener viewPointLayoutDataFlusher;
    private boolean ignoreConsumeState;
    private Map<Diagram, Set<View>> createdViewWithCenterLayout = new HashMap<Diagram, Set<View>>();
    private SiriusLayoutHelper layoutHelper;

    private SiriusLayoutDataManagerImpl() {
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.getSiriusLayoutDataFlusher());
    }

    public static SiriusLayoutDataManager init() {
        return new SiriusLayoutDataManagerImpl();
    }

    @Override
    public void addData(AbstractLayoutData aLayoutData) {
        Iterator<AbstractLayoutData> iterator = this.rootsLayoutData.iterator();
        while (iterator.hasNext()) {
            AbstractLayoutData existingRootLayoutData = iterator.next();
            if (!(existingRootLayoutData instanceof LayoutData) || !(aLayoutData instanceof LayoutData)) continue;
            LayoutData existingLayoutData = (LayoutData)existingRootLayoutData;
            LayoutData aLayoutDataInParam = (LayoutData)aLayoutData;
            if (!existingLayoutData.getTarget().equals(aLayoutDataInParam.getTarget())) continue;
            iterator.remove();
        }
        this.rootsLayoutData.add(aLayoutData);
    }

    @Override
    public LayoutData getData(AbstractDNode node, boolean searchParent) {
        AbstractLayoutData result = null;
        if (node != null) {
            AbstractDNode searchNode = node;
            if (searchParent) {
                if (node.eContainer() instanceof AbstractDNode) {
                    searchNode = (AbstractDNode)node.eContainer();
                } else if (node.eContainer() instanceof DDiagram) {
                    result = this.getData((DDiagram)node.eContainer());
                } else {
                    DiagramPlugin.getDefault().logWarning("This kind of container  (" + node.eContainer().getClass().getName() + ") is not yet managed by the LayoutDataManager.");
                }
            }
            if (result == null) {
                for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
                    LayoutData layoutData;
                    if (abstractLayoutData instanceof LayoutData && (result = (layoutData = (LayoutData)abstractLayoutData).getData(searchNode, this.ignoreConsumeState)) != null) break;
                }
            }
            if (result == null) {
                result = this.getLayoutDataFromEdgeLayoutData(searchNode);
            }
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    private LayoutData getLayoutDataFromEdgeLayoutData(AbstractDNode searchNode) {
        LayoutData result = null;
        for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
            if (!(abstractLayoutData instanceof EdgeLayoutData)) continue;
            EdgeLayoutData edgeLayoutData = (EdgeLayoutData)abstractLayoutData;
            LayoutData edgeSourceLayoutData = edgeLayoutData.getEdgeSourceLayoutData();
            if (edgeSourceLayoutData != null) {
                result = edgeSourceLayoutData.getData(searchNode, this.ignoreConsumeState);
            }
            if (result != null) break;
            LayoutData edgeTargetLayoutData = edgeLayoutData.getEdgeTargetLayoutData();
            if (edgeTargetLayoutData != null) {
                result = edgeTargetLayoutData.getData(searchNode, this.ignoreConsumeState);
            }
            if (result != null) break;
        }
        return result;
    }

    @Override
    public EdgeLayoutData getData(DEdge edge, boolean searchParent) {
        AbstractLayoutData result = null;
        if (result == null) {
            for (AbstractLayoutData abstractLayoutData : this.rootsLayoutData) {
                if (abstractLayoutData instanceof LayoutData) {
                    LayoutData layoutData = (LayoutData)abstractLayoutData;
                    result = layoutData.getData(edge, this.ignoreConsumeState);
                    if (result == null) continue;
                    break;
                }
                if (!(abstractLayoutData instanceof EdgeLayoutData)) continue;
                EdgeLayoutData edgeLayoutData = (EdgeLayoutData)abstractLayoutData;
                EdgeTarget edgeSource = edge.getSourceNode();
                EdgeTarget edgeTarget = edge.getTargetNode();
                LayoutData edgeSourceLayoutData = edgeLayoutData.getEdgeSourceLayoutData();
                LayoutData edgeTargetLayoutData = edgeLayoutData.getEdgeTargetLayoutData();
                if (edgeSource != null && edgeSourceLayoutData instanceof RootLayoutData) {
                    RootLayoutData edgeSourceRootLayoutData = (RootLayoutData)edgeSourceLayoutData;
                    if ((this.ignoreConsumeState || !edgeSourceRootLayoutData.isConsume()) && edgeSource.equals(edgeSourceRootLayoutData.getTarget())) {
                        result = edgeLayoutData;
                        break;
                    }
                }
                if (result != null || edgeTarget == null || !(edgeTargetLayoutData instanceof RootLayoutData)) continue;
                RootLayoutData edgeTargetRootLayoutData = (RootLayoutData)edgeTargetLayoutData;
                if (!this.ignoreConsumeState && edgeTargetRootLayoutData.isConsume() || !edgeTarget.equals(edgeTargetRootLayoutData.getTarget())) continue;
                result = edgeLayoutData;
                break;
            }
        }
        if (result == null) {
            EdgeTarget targetNode;
            EdgeTarget sourceNode = edge.getSourceNode();
            if (sourceNode != null && sourceNode instanceof AbstractDNode) {
                this.getData((AbstractDNode)sourceNode);
            }
            if ((targetNode = edge.getTargetNode()) != null && targetNode instanceof AbstractDNode) {
                this.getData((AbstractDNode)targetNode);
            }
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    protected LayoutData getData(DDiagram diagram) {
        AbstractLayoutData result = null;
        for (AbstractLayoutData layoutData : this.rootsLayoutData) {
            if (layoutData instanceof RootLayoutData) {
                RootLayoutData rootLayoutData = (RootLayoutData)layoutData;
                result = rootLayoutData.getData(diagram, this.ignoreConsumeState);
            }
            if (result != null) break;
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    @Override
    public LayoutData getData(AbstractDNode node) {
        return this.getData(node, false);
    }

    @Override
    public Adapter getAdapterMarker() {
        return LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public Adapter getCenterAdapterMarker() {
        return CENTER_LAYOUT_MARKER_ADAPTER;
    }

    @Override
    public AbstractTransactionalCommand getAddAdapterMakerCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, "Add layout marker on view", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)LAYOUT_MARKER_ADAPTER)) {
                    view.eAdapters().add((Object)LAYOUT_MARKER_ADAPTER);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public AbstractTransactionalCommand getAddCenterAdapterMakerCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, "Add center layout marker on view", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)CENTER_LAYOUT_MARKER_ADAPTER)) {
                    view.eAdapters().add((Object)CENTER_LAYOUT_MARKER_ADAPTER);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    public AbstractTransactionalCommand getAddAdapterMakerOnOpeningCommand(TransactionalEditingDomain domain, final IAdaptable viewAdapter) {
        return new AbstractTransactionalCommand(domain, "Add layout marker on view on opening diagram", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && !view.eAdapters().contains((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING)) {
                    view.eAdapters().add((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public AbstractTransactionalCommand getAddAdapterMakerOnOpeningCommand(TransactionalEditingDomain domain, final View view) {
        return new AbstractTransactionalCommand(domain, "Add layout marker on view on opening diagram", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (view != null && !view.eAdapters().contains((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING)) {
                    view.eAdapters().add((Object)LAYOUT_MARKER_ADAPTER_ON_OPENING);
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public EdgeLabelLayoutData getLabelData(DEdge edge) {
        EdgeLayoutData data;
        AbstractLayoutData result = null;
        if (edge != null && (data = this.getData(edge, false)) != null) {
            result = data.getEdgeLabelLayoutData();
            data.setConsume(false);
        }
        if (result != null) {
            result.setConsume(true);
        }
        return result;
    }

    @Override
    public Command getArrangeCreatedViewsCommand(List<IAdaptable> createdViews, List<IAdaptable> createdViewsWithCenterLayout, IGraphicalEditPart host) {
        if (createdViews != null && createdViews.size() == 1 && this.isAlreadyArrange(createdViews.get(0)) && !this.hasCenterLayout(createdViews.get(0))) {
            this.removeAlreadyArrangeMarker(createdViews.get(0));
            return UnexecutableCommand.INSTANCE;
        }
        return this.getCreatedViewsCommandFromLayoutType(createdViews, createdViewsWithCenterLayout, host);
    }

    private Command getCreatedViewsCommandFromLayoutType(List<IAdaptable> createdViews, List<IAdaptable> createdViewsWithCenterLayout, IGraphicalEditPart host) {
        CompoundCommand cc = new CompoundCommand();
        if (createdViewsWithCenterLayout != null) {
            Point previousCenterLocation = null;
            for (IAdaptable iAdaptable : createdViewsWithCenterLayout) {
                previousCenterLocation = this.calculateCenterLocation(host, cc, iAdaptable, previousCenterLocation);
            }
            return cc;
        }
        return this.arrangeSeveralCreatedViews(createdViews, host);
    }

    private Point calculateCenterLocation(IGraphicalEditPart host, CompoundCommand cc, IAdaptable iAdaptable, Point previousCenterLocation) {
        Point centerLocation;
        Rectangle rect = new Rectangle();
        rect.setSize(LayoutHelper.UNDEFINED.getSize());
        if (previousCenterLocation == null) {
            Point result = this.getLayoutHelper().getReferencePosition(host.getContentPane(), ((FigureCanvas)host.getViewer().getControl()).getViewport(), host);
            rect.setLocation(result);
            Point point = this.getLayoutHelper().validatePosition(host.getContentPane(), rect);
            centerLocation = point.getCopy();
        } else {
            centerLocation = new Point(previousCenterLocation).getTranslated(30, 30);
        }
        IGraphicalEditPart part = (IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(iAdaptable.getAdapter(View.class));
        cc.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(host.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)part, centerLocation)));
        return centerLocation.getCopy();
    }

    private SiriusLayoutHelper getLayoutHelper() {
        if (this.layoutHelper == null) {
            this.layoutHelper = new SiriusLayoutHelper();
        }
        return this.layoutHelper;
    }

    private Command arrangeSeveralCreatedViews(List<IAdaptable> createdViewsAdapters, IGraphicalEditPart host) {
        if (createdViewsAdapters != null) {
            int size = createdViewsAdapters.size();
            CompoundCommand cc = new CompoundCommand();
            if (size > 0) {
                LinkedList<IAdaptable> createdViewsToLayoutAdapters = new LinkedList<IAdaptable>();
                for (IAdaptable viewAdapter : createdViewsAdapters) {
                    if (!this.isAlreadyArrange(viewAdapter)) {
                        createdViewsToLayoutAdapters.add(viewAdapter);
                        continue;
                    }
                    this.removeAlreadyArrangeMarker(viewAdapter);
                }
                if (createdViewsToLayoutAdapters.size() > 0) {
                    DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(host.getEditingDomain(), createdViewsToLayoutAdapters, host);
                    cc.add((Command)new ICommandProxy((ICommand)layoutCmd));
                    return cc;
                }
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public Command getArrangeCreatedViewsOnOpeningCommand(IGraphicalEditPart host) {
        CompoundCommand cc = new CompoundCommand(ARRANGE_COMMAND_LABEL);
        View containerView = (View)host.getModel();
        Command layoutCommand = this.getlayoutCommand(host, containerView);
        if (layoutCommand instanceof CompoundCommand && !((CompoundCommand)layoutCommand).isEmpty()) {
            cc.add(layoutCommand);
        }
        for (Object child : containerView.getChildren()) {
            Command cmd = this.getlayoutCommand((IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(containerView), (View)child);
            if (!(cmd instanceof CompoundCommand) || ((CompoundCommand)cmd).isEmpty()) continue;
            cc.add(cmd);
        }
        if (cc.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return cc;
    }

    private Command getlayoutCommand(IGraphicalEditPart host, View containerView) {
        CompoundCommand cc = new CompoundCommand(ARRANGE_COMMAND_LABEL);
        Collection createdViews = Collections2.filter((Collection)containerView.getChildren(), this.predicate);
        LinkedList createdViewstoLayout = Lists.newLinkedList();
        int size = createdViews.size();
        for (Object view : createdViews) {
            createdViewstoLayout.add(new EObjectAdapter((EObject)((View)view)));
            if (size == 1) continue;
            this.removeAlreadyArrangeMarkeronOpening((View)view);
        }
        if (!createdViewstoLayout.isEmpty() && host != null) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(host.getEditingDomain(), (List)createdViewstoLayout, host);
            cc.add((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        for (Object child : containerView.getChildren()) {
            Command cmd;
            if (host == null || !((cmd = this.getlayoutCommand((IGraphicalEditPart)host.getViewer().getEditPartRegistry().get(containerView), (View)child)) instanceof CompoundCommand) || ((CompoundCommand)cmd).isEmpty()) continue;
            cc.add(cmd);
        }
        return cc;
    }

    private boolean isAlreadyArrange(IAdaptable viewAdapter) {
        boolean alreadyArranged = false;
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                alreadyArranged = true;
                break;
            }
        }
        return alreadyArranged;
    }

    private boolean hasCenterLayout(IAdaptable viewAdapter) {
        boolean centerLayout = false;
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                centerLayout = true;
                break;
            }
        }
        return centerLayout;
    }

    @Override
    public boolean hasToArrange(View view) {
        boolean arranged = false;
        if (view != null) {
            for (Adapter adapter : view.eAdapters()) {
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                arranged = true;
                break;
            }
        }
        return arranged;
    }

    private void removeAlreadyArrangeMarker(IAdaptable viewAdapter) {
        View view = (View)viewAdapter.getAdapter(View.class);
        if (view != null) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                break;
            }
        }
    }

    private void removeAlreadyArrangeMarkeronOpening(View view) {
        if (view != null) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public Command getArrangeCommand(ArrangeRequest request, EditPart host) {
        String layoutDesc = request.getLayoutType() != null ? request.getLayoutType() : "DEFAULT";
        boolean offsetFromBoundingBox = false;
        List editparts = new ArrayList();
        if ("arrangeSelectionAction".equals(request.getType())) {
            editparts = request.getPartsToArrange();
            offsetFromBoundingBox = true;
        }
        if (editparts.isEmpty()) {
            return null;
        }
        ArrayList<LayoutNode> nodes = new ArrayList<LayoutNode>(editparts.size());
        ListIterator li = editparts.listIterator();
        while (li.hasNext()) {
            IGraphicalEditPart ep = (IGraphicalEditPart)li.next();
            View view = ep.getNotationView();
            if (view != null && view instanceof Node) {
                Rectangle bounds = ep.getFigure().getBounds();
                nodes.add(new LayoutNode((Node)view, bounds.width, bounds.height));
            }
            this.removeAlreadyArrangeMarkeronOpening(view);
        }
        ArrayList<String> hints = new ArrayList<String>(2);
        hints.add(layoutDesc);
        hints.add((String)host);
        ObjectAdapter layoutHint = new ObjectAdapter(hints);
        final Runnable layoutRun = this.layoutNodes(nodes, offsetFromBoundingBox, (IAdaptable)layoutHint);
        if (layoutRun instanceof IInternalLayoutRunnable) {
            return ((IInternalLayoutRunnable)layoutRun).getCommand();
        }
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)host).getEditingDomain();
        return new ICommandProxy((ICommand)new AbstractTransactionalCommand(editingDomain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                layoutRun.run();
                return CommandResult.newOKCommandResult();
            }
        });
    }

    private IOperationHistoryListener getSiriusLayoutDataFlusher() {
        if (this.viewPointLayoutDataFlusher == null) {
            this.viewPointLayoutDataFlusher = new SiriusLayoutDataFlusher(this);
        }
        return this.viewPointLayoutDataFlusher;
    }

    protected void flushRootLayoutDatas() {
        this.rootsLayoutData.clear();
    }

    protected void finalize() throws Throwable {
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.viewPointLayoutDataFlusher);
        super.finalize();
    }

    public Runnable layoutNodes(List<LayoutNode> nodes, boolean offsetFromBoundingBox, IAdaptable layoutHint) {
        Runnable layoutRun = LayoutService.getInstance().layoutLayoutNodes(nodes, offsetFromBoundingBox, layoutHint);
        return layoutRun;
    }

    @Override
    public void addCreatedViewsToLayout(Diagram gmfDiagram, LinkedHashSet<View> createdViewsToLayout) {
        this.createdViewToLayout.put(gmfDiagram, createdViewsToLayout);
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewsToLayout() {
        return this.createdViewToLayout;
    }

    @Override
    public void setIgnoreConsumeState(boolean ignoreConsumeState) {
        this.ignoreConsumeState = ignoreConsumeState;
    }

    @Override
    public Option<AbstractLayoutData> getData() {
        if (!this.rootsLayoutData.isEmpty()) {
            return Options.newSome((Object)this.rootsLayoutData.iterator().next());
        }
        return Options.newNone();
    }

    @Override
    public Map<Diagram, Set<View>> getCreatedViewWithCenterLayout() {
        return this.createdViewWithCenterLayout;
    }

    @Override
    public void addCreatedViewWithCenterLayout(Diagram gmfDiagram, LinkedHashSet<View> createdViewsToLayout) {
        this.createdViewWithCenterLayout.put(gmfDiagram, createdViewsToLayout);
    }

    public boolean isCenterLayout(Diagram gmfDiagram, View view) {
        Set<View> set = this.createdViewWithCenterLayout.get(gmfDiagram);
        return set.contains(view);
    }
}

