/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Preconditions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.ext.swt.ImageFileFormat;
import org.eclipse.swt.graphics.Image;

public class WorkspaceImageQuery {
    private static final Dimension DEFAULT_WORKSPACE_DIMENSION = new Dimension(2, 2);
    private final WorkspaceImageDescription workspaceImage;

    public WorkspaceImageQuery(WorkspaceImageDescription workspaceImage) {
        this.workspaceImage = (WorkspaceImageDescription)Preconditions.checkNotNull((Object)workspaceImage);
    }

    public Dimension getDefaultDimension() {
        Dimension result = DEFAULT_WORKSPACE_DIMENSION.getCopy();
        String path = this.workspaceImage.getWorkspacePath();
        Image image = path != null && path.toUpperCase().endsWith(ImageFileFormat.SVG.getName()) ? SVGWorkspaceImageFigure.flyWeightImage(path) : WorkspaceImageFigure.flyWeightImage(path);
        if (image != null) {
            result.width = image.getBounds().width;
            result.height = image.getBounds().height;
        }
        return result;
    }
}

