/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.query;

import com.google.common.base.Preconditions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SVGWorkspaceImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.WorkspaceImageFigure;
import org.eclipse.sirius.ext.swt.ImageFileFormat;
import org.eclipse.swt.graphics.Image;

public class DNodeQuery {
    private static final Dimension DEFAULT_NODE_DIMENSION = new Dimension(2, 2);
    private final DNode node;

    public DNodeQuery(DNode node) {
        this.node = (DNode)Preconditions.checkNotNull((Object)node);
    }

    public Dimension getDefaultDimension() {
        Dimension result = DEFAULT_NODE_DIMENSION.getCopy();
        if (this.node.getStyle() instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)this.node.getStyle();
            String path = workspaceImage.getWorkspacePath();
            Image image = path != null && path.toUpperCase().endsWith(ImageFileFormat.SVG.getName()) ? SVGWorkspaceImageFigure.flyWeightImage(path) : WorkspaceImageFigure.flyWeightImage(path);
            if (image != null) {
                if (this.node.getWidth() == null || Integer.valueOf(this.node.getWidth()) == -1) {
                    result.width = image.getBounds().width;
                    result.height = image.getBounds().height;
                } else {
                    double ratio = (double)image.getBounds().width / (double)image.getBounds().height;
                    double newHeight = (double)this.node.getWidth().intValue() / ratio;
                    result.width = this.node.getWidth() * 10;
                    result.height = (int)(newHeight * 10.0);
                }
            }
        } else {
            if (this.node.getWidth() != null) {
                result.width = this.node.getWidth();
            }
            if (this.node.getHeight() != null) {
                result.height = this.node.getHeight();
            }
            result.width *= 10;
            result.height *= 10;
        }
        return result;
    }
}

