/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.view;

import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public final class SiriusGMFHelper {
    private static final int[] LABEL_VISUAL_IDS = new int[]{6001, 6003, 6002, 5005, 5006, 3010, 5004, 5007, 5001, 5003, 5010, 5002};

    static {
        Arrays.sort(LABEL_VISUAL_IDS);
    }

    private SiriusGMFHelper() {
    }

    public static Diagram getGmfDiagram(DDiagram diagram) {
        return SiriusGMFHelper.getGmfView((EObject)diagram, Diagram.class);
    }

    public static Edge getGmfEdge(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, Edge.class);
    }

    public static Node getGmfNode(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, Node.class);
    }

    public static View getGmfView(DDiagramElement diagramElement) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, View.class);
    }

    public static View getGmfView(DSemanticDecorator element) {
        return SiriusGMFHelper.getGmfView((EObject)element, View.class);
    }

    public static Diagram getGmfDiagram(DDiagram diagram, Session session) {
        return SiriusGMFHelper.getGmfView((EObject)diagram, Diagram.class, session);
    }

    public static Edge getGmfEdge(DDiagramElement diagramElement, Session session) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, Edge.class, session);
    }

    public static Edge getGmfEdge(DDiagramElement diagramElement, ECrossReferenceAdapter crossReference) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, Edge.class, crossReference);
    }

    public static Node getGmfNode(DDiagramElement diagramElement, Session session) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, Node.class, session);
    }

    public static View getGmfView(DDiagramElement diagramElement, Session session) {
        return SiriusGMFHelper.getGmfView((EObject)diagramElement, View.class, session);
    }

    public static View getGmfView(DSemanticDecorator element, Session session) {
        return SiriusGMFHelper.getGmfView((EObject)element, View.class, session);
    }

    private static <T> T getGmfView(EObject diagramElement, Class<T> clazz) {
        if (diagramElement instanceof DSemanticDecorator) {
            EObject semanticElement = ((DSemanticDecorator)diagramElement).getTarget();
            Session sessionToUse = semanticElement != null ? SiriusGMFHelper.getSession(semanticElement) : SiriusGMFHelper.getSession(diagramElement);
            return SiriusGMFHelper.getGmfView(diagramElement, clazz, sessionToUse);
        }
        return null;
    }

    private static <T> T getGmfView(EObject diagramElement, Class<T> clazz, Session session) {
        EObject semanticElement;
        Session sessionToUse;
        if (diagramElement instanceof DSemanticDecorator && (sessionToUse = session == null ? ((semanticElement = ((DSemanticDecorator)diagramElement).getTarget()) != null ? SiriusGMFHelper.getSession(semanticElement) : SiriusGMFHelper.getSession(diagramElement)) : session) != null) {
            ECrossReferenceAdapter crossReference = sessionToUse.getSemanticCrossReferencer();
            return SiriusGMFHelper.getGmfView(diagramElement, clazz, crossReference);
        }
        return null;
    }

    private static <T> T getGmfView(EObject diagramElement, Class<T> clazz, ECrossReferenceAdapter semanticCrossReference) {
        if (semanticCrossReference != null) {
            for (EStructuralFeature.Setting setting : semanticCrossReference.getInverseReferences(diagramElement)) {
                if (!clazz.isInstance(setting.getEObject()) || setting.getEStructuralFeature() != NotationPackage.eINSTANCE.getView_Element()) continue;
                return (T)setting.getEObject();
            }
        }
        return null;
    }

    private static Session getSession(EObject eObject) {
        return SessionManager.INSTANCE.getSession(eObject);
    }

    public static Node getLabelNode(View gmfView) {
        View labelView;
        Node result = null;
        if (!gmfView.getChildren().isEmpty() && (labelView = (View)gmfView.getChildren().iterator().next()) instanceof Node && SiriusGMFHelper.isLabel(labelView)) {
            result = (Node)labelView;
        }
        return result;
    }

    private static boolean isLabel(View gmfView) {
        int visualId = SiriusVisualIDRegistry.getVisualID(gmfView);
        return Arrays.binarySearch(LABEL_VISUAL_IDS, visualId) >= 0;
    }

    public static String getViewId(View view) {
        String uriFragment;
        String viewId = "";
        if (view.eResource() != null && (uriFragment = view.eResource().getURIFragment((EObject)view)) != null) {
            viewId = uriFragment;
        }
        return viewId;
    }
}

