/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCache {
    private final Map<File, Reference<Repository>> repositoryCache = new HashMap<File, Reference<Repository>>();

    RepositoryCache() {
    }

    public synchronized Repository lookupRepository(File gitDir) throws IOException {
        Repository d;
        RepositoryCache.prune(this.repositoryCache);
        Reference<Repository> r = this.repositoryCache.get(gitDir);
        Repository repository = d = r != null ? r.get() : null;
        if (d == null) {
            d = FileRepositoryBuilder.create((File)gitDir);
            this.repositoryCache.put(gitDir, new WeakReference<Repository>(d));
        }
        return d;
    }

    public synchronized Repository[] getAllRepositories() {
        RepositoryCache.prune(this.repositoryCache);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (Reference<Repository> reference : this.repositoryCache.values()) {
            repositories.add(reference.get());
        }
        return repositories.toArray(new Repository[repositories.size()]);
    }

    public Repository getRepository(IResource resource) {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return this.getRepository(location);
    }

    public Repository getRepository(IPath location) {
        Repository[] repositories = Activator.getDefault().getRepositoryCache().getAllRepositories();
        Repository repository = null;
        int largestSegmentCount = 0;
        Repository[] repositoryArray = repositories;
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository r = repositoryArray[n2];
            if (!r.isBare()) {
                try {
                    Path repoPath = new Path(r.getWorkTree().getCanonicalPath());
                    if (location != null && repoPath.isPrefixOf(location) && (repository == null || repoPath.segmentCount() > largestSegmentCount)) {
                        repository = r;
                        largestSegmentCount = repoPath.segmentCount();
                    }
                }
                catch (IOException e) {
                    Activator.error("looking up working tree path of git repository failed", e);
                }
            }
            ++n2;
        }
        return repository;
    }

    private static void prune(Map<File, Reference<Repository>> map) {
        Iterator<Map.Entry<File, Reference<Repository>>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Repository repository = i.next().getValue().get();
            if (repository != null && repository.getDirectory().exists()) continue;
            i.remove();
        }
    }

    public void clear() {
        this.repositoryCache.clear();
    }
}

